/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.builder.sql.Dialect;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Optional;
import java.util.OptionalInt;

@Internal
final class SqlQueryBuilderUtils {
    private SqlQueryBuilderUtils() {
    }

    static String addTypeToColumn(PersistentProperty prop, String column, Dialect dialect, boolean required) {
        if (prop instanceof Association) {
            throw new IllegalStateException("Association is not supported here");
        }
        AnnotationMetadata annotationMetadata = prop.getAnnotationMetadata();
        String definition = annotationMetadata.stringValue(MappedProperty.class, "definition").orElse(null);
        DataType dataType = prop.getDataType();
        if (definition != null) {
            return column + " " + definition;
        }
        OptionalInt precision = annotationMetadata.intValue("javax.persistence.Column", "precision");
        OptionalInt scale = annotationMetadata.intValue("javax.persistence.Column", "scale");
        switch (dataType) {
            case STRING: {
                int stringLength = annotationMetadata.findAnnotation("javax.validation.constraints.Size$List").flatMap(v -> {
                    Optional value = v.getValue(AnnotationValue.class);
                    return value;
                }).map(v -> v.intValue("max")).orElseGet(() -> annotationMetadata.intValue("javax.persistence.Column", "length")).orElse(255);
                column = column + " VARCHAR(" + stringLength + ")";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case UUID: {
                column = dialect == Dialect.ORACLE || dialect == Dialect.MYSQL ? column + " VARCHAR(36)" : (dialect == Dialect.SQL_SERVER ? column + " UNIQUEIDENTIFIER" : column + " UUID");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BOOLEAN: {
                if (dialect == Dialect.ORACLE) {
                    column = column + " NUMBER(3)";
                    break;
                }
                if (dialect == Dialect.SQL_SERVER) {
                    column = column + " BIT NOT NULL";
                    break;
                }
                column = column + " BOOLEAN";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case TIMESTAMP: {
                if (dialect == Dialect.ORACLE) {
                    column = column + " TIMESTAMP";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (dialect == Dialect.SQL_SERVER) {
                    column = column + " DATETIME2";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (dialect == Dialect.MYSQL) {
                    column = column + " TIMESTAMP(6) DEFAULT NOW(6)";
                    break;
                }
                column = column + " TIMESTAMP";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case DATE: {
                column = column + " DATE";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case LONG: {
                column = dialect == Dialect.ORACLE ? column + " NUMBER(19)" : column + " BIGINT";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case CHARACTER: {
                column = column + " CHAR(1)";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case INTEGER: {
                if (precision.isPresent()) {
                    String numericName = dialect == Dialect.ORACLE ? "NUMBER" : "NUMERIC";
                    column = column + " " + numericName + "(" + precision.getAsInt() + ")";
                } else {
                    column = dialect == Dialect.ORACLE ? column + " NUMBER(10)" : (dialect == Dialect.POSTGRES ? column + " INTEGER" : column + " INT");
                }
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BIGDECIMAL: {
                if (precision.isPresent()) {
                    if (scale.isPresent()) {
                        String numericName = dialect == Dialect.ORACLE ? "NUMBER" : "NUMERIC";
                        column = column + " " + numericName + "(" + precision.getAsInt() + "," + scale.getAsInt() + ")";
                    } else {
                        column = column + " FLOAT(" + precision.getAsInt() + ")";
                    }
                } else {
                    column = dialect == Dialect.ORACLE ? column + " FLOAT(126)" : column + " DECIMAL";
                }
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case FLOAT: {
                if (precision.isPresent()) {
                    if (scale.isPresent()) {
                        String numericName = dialect == Dialect.ORACLE ? "NUMBER" : "NUMERIC";
                        column = column + " " + numericName + "(" + precision.getAsInt() + "," + scale.getAsInt() + ")";
                    } else {
                        column = column + " FLOAT(" + precision.getAsInt() + ")";
                    }
                } else {
                    column = dialect == Dialect.ORACLE || dialect == Dialect.SQL_SERVER ? column + " FLOAT(53)" : (dialect == Dialect.POSTGRES ? column + " REAL" : column + " FLOAT");
                }
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BYTE_ARRAY: {
                column = dialect == Dialect.POSTGRES ? column + " BYTEA" : (dialect == Dialect.SQL_SERVER ? column + " VARBINARY(MAX)" : (dialect == Dialect.ORACLE ? column + " BLOB" : column + " BLOB"));
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case DOUBLE: {
                if (precision.isPresent()) {
                    if (scale.isPresent()) {
                        String numericName = dialect == Dialect.ORACLE ? "NUMBER" : "NUMERIC";
                        column = column + " " + numericName + "(" + precision.getAsInt() + "," + scale.getAsInt() + ")";
                    } else {
                        column = column + " FLOAT(" + precision.getAsInt() + ")";
                    }
                } else {
                    column = dialect == Dialect.ORACLE ? column + " FLOAT(23)" : (dialect == Dialect.MYSQL || dialect == Dialect.H2 ? column + " DOUBLE" : column + " DOUBLE PRECISION");
                }
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case SHORT: 
            case BYTE: {
                column = dialect == Dialect.ORACLE ? column + " NUMBER(5)" : (dialect == Dialect.POSTGRES ? column + " SMALLINT" : column + " TINYINT");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case JSON: {
                switch (dialect) {
                    case POSTGRES: {
                        column = column + " JSONB";
                        break;
                    }
                    case SQL_SERVER: {
                        column = column + " NVARCHAR(MAX)";
                        break;
                    }
                    case ORACLE: {
                        column = column + " CLOB";
                        break;
                    }
                    default: {
                        column = column + " JSON";
                    }
                }
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case STRING_ARRAY: 
            case CHARACTER_ARRAY: {
                column = dialect == Dialect.H2 ? column + " ARRAY" : column + " VARCHAR(255) ARRAY";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case SHORT_ARRAY: {
                column = dialect == Dialect.H2 ? column + " ARRAY" : (dialect == Dialect.POSTGRES ? column + " SMALLINT ARRAY" : column + " TINYINT ARRAY");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case INTEGER_ARRAY: {
                column = dialect == Dialect.H2 ? column + " ARRAY" : (dialect == Dialect.POSTGRES ? column + " INTEGER ARRAY" : column + " INT ARRAY");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case LONG_ARRAY: {
                column = dialect == Dialect.H2 ? column + " ARRAY" : column + " BIGINT ARRAY";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case FLOAT_ARRAY: {
                column = dialect == Dialect.H2 ? column + " ARRAY" : (dialect == Dialect.POSTGRES ? column + " REAL ARRAY" : column + " FLOAT ARRAY");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case DOUBLE_ARRAY: {
                column = dialect == Dialect.H2 ? column + " ARRAY" : (dialect == Dialect.POSTGRES ? column + " DOUBLE PRECISION ARRAY" : column + " DOUBLE ARRAY");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BOOLEAN_ARRAY: {
                column = dialect == Dialect.H2 ? column + " ARRAY" : column + " BOOLEAN ARRAY";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            default: {
                if (prop.isEnum()) {
                    column = column + " VARCHAR(255)";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (prop.isAssignable(Clob.class)) {
                    column = dialect == Dialect.POSTGRES ? column + " TEXT" : column + " CLOB";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (prop.isAssignable(Blob.class)) {
                    column = dialect == Dialect.POSTGRES ? column + " BYTEA" : column + " BLOB";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                throw new MappingException("Unable to create table column for property [" + prop.getName() + "] of entity [" + prop.getOwner().getName() + "] with unknown data type: " + (Object)((Object)dataType));
            }
        }
        return column;
    }
}

