/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.naming;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategies;
import java.util.List;

@FunctionalInterface
@Introspected
public interface NamingStrategy {
    public static final NamingStrategy DEFAULT = new NamingStrategies.UnderScoreSeparatedLowerCase();

    @NonNull
    public String mappedName(@NonNull String var1);

    @NonNull
    default public String mappedName(@NonNull PersistentEntity entity) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class).filter(StringUtils::isNotEmpty).orElseGet(() -> this.mappedName(entity.getSimpleName()));
    }

    @NonNull
    default public String mappedName(Embedded embedded, PersistentProperty property) {
        return this.mappedName(embedded.getName() + NameUtils.capitalize((String)property.getPersistedName()));
    }

    @NonNull
    default public String mappedName(@NonNull PersistentProperty property) {
        ArgumentUtils.requireNonNull((String)"property", (Object)property);
        if (property instanceof Association) {
            return this.mappedName((Association)property);
        }
        return property.getAnnotationMetadata().stringValue(MappedProperty.class).filter(StringUtils::isNotEmpty).orElseGet(() -> this.mappedName(property.getName()));
    }

    @NonNull
    default public String mappedName(Association association) {
        String providedName = association.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
        if (providedName != null) {
            return providedName;
        }
        if (association.isForeignKey()) {
            return this.mappedName(association.getOwner().getDecapitalizedName() + association.getAssociatedEntity().getSimpleName());
        }
        switch (association.getKind()) {
            case ONE_TO_ONE: 
            case MANY_TO_ONE: {
                return this.mappedName(association.getName() + this.getForeignKeySuffix());
            }
        }
        return this.mappedName(association.getName());
    }

    @NonNull
    default public String mappedName(@NonNull List<Association> associations, @NonNull PersistentProperty property) {
        String providedName;
        if (associations.isEmpty()) {
            return this.mappedName(property);
        }
        StringBuilder sb = new StringBuilder();
        Association foreignAssociation = null;
        for (Association association : associations) {
            if (association.getKind() != Relation.Kind.EMBEDDED && foreignAssociation == null) {
                foreignAssociation = association;
            }
            if (sb.length() > 0) {
                sb.append(NameUtils.capitalize((String)association.getName()));
                continue;
            }
            sb.append(association.getName());
        }
        if (foreignAssociation != null) {
            if (foreignAssociation.getAssociatedEntity() == property.getOwner() && foreignAssociation.getAssociatedEntity().getIdentity() == property) {
                providedName = foreignAssociation.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                if (providedName != null) {
                    return providedName;
                }
                sb.append(this.getForeignKeySuffix());
                return this.mappedName(sb.toString());
            }
            if (foreignAssociation.isForeignKey()) {
                throw new IllegalStateException("Foreign association cannot be mapped!");
            }
        } else {
            providedName = property.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
            if (providedName != null) {
                return providedName;
            }
        }
        if (sb.length() > 0) {
            sb.append(NameUtils.capitalize((String)property.getName()));
        } else {
            sb.append(property.getName());
        }
        return this.mappedName(sb.toString());
    }

    default public String mappedJoinTableColumn(PersistentEntity associated, List<Association> associations, PersistentProperty property) {
        StringBuilder sb = new StringBuilder();
        sb.append(associated.getDecapitalizedName());
        for (Association association : associations) {
            sb.append(NameUtils.capitalize((String)association.getName()));
        }
        if (associations.isEmpty()) {
            sb.append(this.getForeignKeySuffix());
        } else {
            sb.append(NameUtils.capitalize((String)property.getName()));
        }
        return this.mappedName(sb.toString());
    }

    @NonNull
    default public String getForeignKeySuffix() {
        return "Id";
    }
}

