/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.AbstractPersistentEntity;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEmbedded;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RuntimePersistentEntity<T>
extends AbstractPersistentEntity
implements PersistentEntity {
    private final BeanIntrospection<T> introspection;
    private final RuntimePersistentProperty<T> identity;
    private final Map<String, RuntimePersistentProperty<T>> persistentProperties;
    private final RuntimePersistentProperty<T>[] constructorArguments;
    private final String aliasName;
    private RuntimePersistentProperty<T> version;
    private Boolean hasAutoPopulatedProperties;

    public RuntimePersistentEntity(@NonNull Class<T> type) {
        this(BeanIntrospection.getIntrospection(type));
    }

    public RuntimePersistentEntity(@NonNull BeanIntrospection<T> introspection) {
        super((AnnotationMetadataProvider)introspection);
        ArgumentUtils.requireNonNull((String)"introspection", introspection);
        this.introspection = introspection;
        Argument[] constructorArguments = introspection.getConstructorArguments();
        Set constructorArgumentNames = Arrays.stream(constructorArguments).map(Argument::getName).collect(Collectors.toSet());
        this.identity = introspection.getIndexedProperty(Id.class).map(bp -> {
            if (bp.enumValue(Relation.class, Relation.Kind.class).map(k -> k == Relation.Kind.EMBEDDED).orElse(false).booleanValue()) {
                return new RuntimeEmbedded(this, bp, constructorArgumentNames.contains(bp.getName()));
            }
            return new RuntimePersistentProperty(this, bp, constructorArgumentNames.contains(bp.getName()));
        }).orElse(null);
        this.version = introspection.getIndexedProperty(Version.class).map(bp -> new RuntimePersistentProperty(this, bp, constructorArgumentNames.contains(bp.getName()))).orElse(null);
        Collection beanProperties = introspection.getBeanProperties();
        this.persistentProperties = new LinkedHashMap<String, RuntimePersistentProperty<T>>(beanProperties.size());
        for (BeanProperty bp2 : beanProperties) {
            if (bp2.hasStereotype(new Class[]{Id.class, Version.class})) continue;
            RuntimeAssociation prop = bp2.hasAnnotation(Relation.class) ? (this.isEmbedded(bp2) ? new RuntimeEmbedded(this, bp2, constructorArgumentNames.contains(bp2.getName())) : new RuntimeAssociation(this, bp2, constructorArgumentNames.contains(bp2.getName()))) : new RuntimeAssociation(this, bp2, constructorArgumentNames.contains(bp2.getName()));
            this.persistentProperties.put(prop.getName(), prop);
        }
        this.constructorArguments = new RuntimePersistentProperty[constructorArguments.length];
        for (int i = 0; i < constructorArguments.length; ++i) {
            PersistentProperty identity;
            Argument constructorArgument = constructorArguments[i];
            String argumentName = constructorArgument.getName();
            PersistentProperty prop = this.getPropertyByName(argumentName);
            if (prop == null && (identity = this.getIdentity()) != null && !((RuntimePersistentProperty)identity).getName().equals(argumentName)) {
                throw new MappingException("Constructor argument [" + argumentName + "] for type [" + this.getName() + "] must have an associated getter");
            }
            this.constructorArguments[i] = prop;
        }
        this.aliasName = super.getAliasName();
    }

    public boolean hasPrePersistEventListeners() {
        return false;
    }

    public boolean hasPreRemoveEventListeners() {
        return false;
    }

    public boolean hasPreUpdateEventListeners() {
        return false;
    }

    public boolean hasPostPersistEventListeners() {
        return false;
    }

    public boolean hasPostUpdateEventListeners() {
        return false;
    }

    public boolean hasPostRemoveEventListeners() {
        return false;
    }

    public boolean hasPostLoadEventListeners() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @NonNull
    public String getAliasName() {
        return this.aliasName;
    }

    public BeanIntrospection<T> getIntrospection() {
        return this.introspection;
    }

    @Override
    @NonNull
    public String getName() {
        return this.introspection.getBeanType().getName();
    }

    @Override
    @Nullable
    public PersistentProperty[] getCompositeIdentity() {
        return new PersistentProperty[0];
    }

    @Override
    @Nullable
    public RuntimePersistentProperty<T> getIdentity() {
        return this.identity;
    }

    @Override
    @Nullable
    public RuntimePersistentProperty<T> getVersion() {
        return this.version;
    }

    @NonNull
    public Collection<RuntimePersistentProperty<T>> getPersistentProperties() {
        return this.persistentProperties.values();
    }

    @NonNull
    public Collection<RuntimeAssociation<T>> getAssociations() {
        return this.persistentProperties.values().stream().filter(bp -> bp.getAnnotationMetadata().hasStereotype(Relation.class)).map(p -> (RuntimeAssociation)p).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public Collection<Embedded> getEmbedded() {
        return this.persistentProperties.values().stream().filter(pp -> pp instanceof Embedded).map(pp -> (Embedded)((Object)pp)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public RuntimePersistentProperty<T> getPropertyByName(String name) {
        PersistentProperty identity;
        RuntimePersistentProperty<T> property = this.persistentProperties.get(name);
        if (property == null && (identity = this.getIdentity()) != null && ((RuntimePersistentProperty)identity).getName().equals(name)) {
            return identity;
        }
        return property;
    }

    @NonNull
    public List<String> getPersistentPropertyNames() {
        return Arrays.asList(this.introspection.getPropertyNames());
    }

    @Override
    public boolean isOwningEntity(PersistentEntity owner) {
        return true;
    }

    @Override
    @Nullable
    public PersistentEntity getParentEntity() {
        return null;
    }

    private boolean isEmbedded(BeanProperty bp) {
        return bp.enumValue(Relation.class, Relation.Kind.class).orElse(null) == Relation.Kind.EMBEDDED;
    }

    protected RuntimePersistentEntity<T> getEntity(Class<T> type) {
        return PersistentEntity.of(type);
    }

    public RuntimePersistentProperty<T>[] getConstructorArguments() {
        return this.constructorArguments;
    }

    public boolean hasAutoPopulatedProperties() {
        if (this.hasAutoPopulatedProperties == null) {
            PersistentProperty identity = this.getIdentity();
            boolean hasAutoPopulated = this.isAutoPopulatedProperty((RuntimePersistentProperty<T>)identity);
            if (!hasAutoPopulated) {
                hasAutoPopulated = this.persistentProperties.values().stream().anyMatch(PersistentProperty::isAutoPopulated);
            }
            this.hasAutoPopulatedProperties = hasAutoPopulated;
        }
        return this.hasAutoPopulatedProperties;
    }

    private boolean isAutoPopulatedProperty(RuntimePersistentProperty<T> identity) {
        return identity != null && identity.isAutoPopulated();
    }
}

