/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import java.util.List;

@Introspected
public interface QueryBuilder {
    @Nullable
    public QueryResult buildInsert(AnnotationMetadata var1, PersistentEntity var2);

    @NonNull
    public QueryResult buildQuery(@NonNull QueryModel var1);

    @NonNull
    public QueryResult buildUpdate(@NonNull QueryModel var1, List<String> var2);

    @NonNull
    public QueryResult buildDelete(@NonNull QueryModel var1);

    @NonNull
    public QueryResult buildOrderBy(@NonNull PersistentEntity var1, @NonNull Sort var2);

    @NonNull
    public QueryResult buildPagination(@NonNull Pageable var1);

    @NonNull
    public static QueryBuilder newQueryBuilder(@NonNull AnnotationMetadata annotationMetadata) {
        if (annotationMetadata == null) {
            return new JpaQueryBuilder();
        }
        return annotationMetadata.stringValue(RepositoryConfiguration.class, "queryBuilder").flatMap(type -> BeanIntrospector.SHARED.findIntrospections(ref -> ref.isPresent() && ref.getBeanType().getName().equals(type)).stream().findFirst().map(introspection -> {
            try {
                Argument[] constructorArguments = introspection.getConstructorArguments();
                if (constructorArguments.length == 0) {
                    return (QueryBuilder)introspection.instantiate();
                }
                if (constructorArguments.length == 1 && constructorArguments[0].getType() == AnnotationMetadata.class) {
                    return (QueryBuilder)introspection.instantiate(new Object[]{annotationMetadata});
                }
            }
            catch (InstantiationException e) {
                return new JpaQueryBuilder();
            }
            return new JpaQueryBuilder();
        })).orElse(new JpaQueryBuilder());
    }
}

