/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;

@Singleton
@Internal
public final class DataIntroductionAdvice
implements MethodInterceptor<Object, Object> {
    private final BeanLocator beanLocator;
    private final Map<RepositoryMethodKey, DataInterceptor> interceptorMap = new ConcurrentHashMap<RepositoryMethodKey, DataInterceptor>(20);

    DataIntroductionAdvice(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        RepositoryMethodKey key = new RepositoryMethodKey(context.getTarget(), context.getExecutableMethod());
        DataInterceptor dataInterceptor = this.interceptorMap.get(key);
        if (dataInterceptor == null) {
            String dataSourceName = context.stringValue(Repository.class).orElse(null);
            Class<RepositoryOperations> operationsType = context.classValue(RepositoryConfiguration.class, "operations").orElse(RepositoryOperations.class);
            Class interceptorType = context.classValue(DataMethod.class, "interceptor").orElse(null);
            if (interceptorType != null && DataInterceptor.class.isAssignableFrom(interceptorType)) {
                DataInterceptor<Object, Object> childInterceptor = this.findInterceptor(dataSourceName, operationsType, interceptorType);
                this.interceptorMap.put(key, childInterceptor);
                return childInterceptor.intercept(key, context);
            }
            return context.proceed();
        }
        return dataInterceptor.intercept(key, context);
    }

    @NonNull
    private DataInterceptor<Object, Object> findInterceptor(@Nullable String dataSourceName, @NonNull Class<?> operationsType, @NonNull Class<?> interceptorType) {
        RepositoryOperations datastore;
        if (!RepositoryOperations.class.isAssignableFrom(operationsType)) {
            throw new IllegalArgumentException("Repository type must be an instance of RepositoryOperations!");
        }
        try {
            if (dataSourceName != null) {
                Qualifier qualifier = Qualifiers.byName((String)dataSourceName);
                datastore = (RepositoryOperations)this.beanLocator.getBean(operationsType, qualifier);
            } else {
                datastore = (RepositoryOperations)this.beanLocator.getBean(operationsType);
            }
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No backing RepositoryOperations configured for repository. Check your configuration and try again", (Throwable)e);
        }
        BeanIntrospection introspection = (BeanIntrospection)BeanIntrospector.SHARED.findIntrospections(ref -> interceptorType.isAssignableFrom(ref.getBeanType())).stream().findFirst().orElseThrow(() -> new DataAccessException("No Data interceptor found for type: " + interceptorType));
        DataInterceptor interceptor = introspection.getConstructorArguments().length == 0 ? (DataInterceptor)introspection.instantiate() : (DataInterceptor)introspection.instantiate(new Object[]{datastore});
        return interceptor;
    }
}

