/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;

public class RuntimePersistentProperty<T>
implements PersistentProperty {
    private final RuntimePersistentEntity<T> owner;
    private final BeanProperty<T, ?> property;
    private final Class<?> type;
    private final DataType dataType;
    private final boolean constructorArg;

    RuntimePersistentProperty(RuntimePersistentEntity<T> owner, BeanProperty<T, ?> property, boolean constructorArg) {
        this.owner = owner;
        this.property = property;
        this.type = ReflectionUtils.getWrapperType((Class)property.getType());
        this.dataType = PersistentProperty.super.getDataType();
        this.constructorArg = constructorArg;
    }

    @Override
    public boolean isConstructorArgument() {
        return this.constructorArg;
    }

    @Override
    public final boolean isOptional() {
        return this.property.isNullable();
    }

    @Override
    public boolean isEnum() {
        return this.type.isEnum();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isReadOnly() {
        return this.property.isReadOnly() || this.isGenerated();
    }

    @NonNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    @NonNull
    public String getName() {
        return this.property.getName();
    }

    @Override
    @NonNull
    public String getTypeName() {
        return this.property.getType().getName();
    }

    @Override
    @NonNull
    public RuntimePersistentEntity<T> getOwner() {
        return this.owner;
    }

    @Override
    public boolean isAssignable(@NonNull String type) {
        throw new UnsupportedOperationException("Use isAssignable(Class) instead");
    }

    @Override
    public boolean isAssignable(@NonNull Class<?> type) {
        return type.isAssignableFrom(this.getProperty().getType());
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.property.getAnnotationMetadata();
    }

    public BeanProperty<T, ?> getProperty() {
        return this.property;
    }

    @Override
    @NonNull
    public String getPersistedName() {
        return this.owner.getNamingStrategy().mappedName(this);
    }

    public String toString() {
        return this.getOwner().getSimpleName() + "." + this.getName();
    }
}

