/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.config.DataJdbcConfiguration;
import io.micronaut.data.jdbc.convert.JdbcConversionContext;
import io.micronaut.data.jdbc.mapper.ColumnIndexResultSetReader;
import io.micronaut.data.jdbc.mapper.ColumnNameResultSetReader;
import io.micronaut.data.jdbc.mapper.JdbcQueryStatement;
import io.micronaut.data.jdbc.mapper.SqlResultConsumer;
import io.micronaut.data.jdbc.operations.JdbcRepositoryOperations;
import io.micronaut.data.jdbc.runtime.ConnectionCallback;
import io.micronaut.data.jdbc.runtime.PreparedStatementCallback;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.RuntimePersistentPropertyConversionContext;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.DTOMapper;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultConsumer;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSqlRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSyncEntitiesOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSyncEntityOperations;
import io.micronaut.data.runtime.operations.internal.DBOperation;
import io.micronaut.data.runtime.operations.internal.OpContext;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.StoredQuerySqlOperation;
import io.micronaut.data.runtime.operations.internal.StoredSqlOperation;
import io.micronaut.data.runtime.operations.internal.SyncCascadeOperations;
import io.micronaut.data.runtime.support.AbstractConversionContext;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.jdbc.DataSourceUtils;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=DataSource.class)
@Internal
public final class DefaultJdbcRepositoryOperations
extends AbstractSqlRepositoryOperations<Connection, ResultSet, PreparedStatement, SQLException>
implements JdbcRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
AutoCloseable,
SyncCascadeOperations.SyncCascadeOperationsHelper<JdbcOperationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJdbcRepositoryOperations.class);
    private final TransactionOperations<Connection> transactionOperations;
    private final DataSource dataSource;
    private final DataSource unwrapedDataSource;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;
    private final SyncCascadeOperations<JdbcOperationContext> cascadeOperations;
    private final DataJdbcConfiguration jdbcConfiguration;

    @Internal
    protected DefaultJdbcRepositoryOperations(@Parameter String dataSourceName, @Parameter DataJdbcConfiguration jdbcConfiguration, DataSource dataSource, @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, BeanContext beanContext, List<MediaTypeCodec> codecs, @NonNull DateTimeProvider dateTimeProvider, RuntimeEntityRegistry entityRegistry, DataConversionService<?> conversionService, AttributeConverterRegistry attributeConverterRegistry) {
        super(dataSourceName, (ResultReader)new ColumnNameResultSetReader(conversionService), (ResultReader)new ColumnIndexResultSetReader(conversionService), (QueryStatement)new JdbcQueryStatement(conversionService), codecs, dateTimeProvider, entityRegistry, beanContext, conversionService, attributeConverterRegistry);
        ArgumentUtils.requireNonNull((String)"dataSource", (Object)dataSource);
        ArgumentUtils.requireNonNull((String)"transactionOperations", transactionOperations);
        this.dataSource = dataSource;
        this.unwrapedDataSource = DelegatingDataSource.unwrapDataSource((DataSource)dataSource);
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
        this.cascadeOperations = new SyncCascadeOperations(conversionService, (SyncCascadeOperations.SyncCascadeOperationsHelper)this);
        this.jdbcConfiguration = jdbcConfiguration;
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    public <T> T persistOne(JdbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        DBOperation childSqlPersistOperation = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        JdbcEntityOperations persistOneOp = new JdbcEntityOperations(ctx, childSqlPersistOperation, persistentEntity, value, true);
        persistOneOp.persist();
        return (T)persistOneOp.getEntity();
    }

    public <T> List<T> persistBatch(JdbcOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> childPersistentEntity, Predicate<T> predicate) {
        DBOperation childSqlPersistOperation = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, childPersistentEntity.getIntrospection().getBeanType(), childPersistentEntity);
        JdbcEntitiesOperations persistBatchOp = new JdbcEntitiesOperations(ctx, childPersistentEntity, values, childSqlPersistOperation, true);
        persistBatchOp.veto(predicate);
        persistBatchOp.persist();
        return persistBatchOp.getEntities();
    }

    public <T> T updateOne(JdbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        DBOperation childSqlUpdateOperation = this.resolveEntityUpdate(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        JdbcEntityOperations op = new JdbcEntityOperations(ctx, persistentEntity, value, childSqlUpdateOperation);
        op.update();
        return (T)op.getEntity();
    }

    public void persistManyAssociation(JdbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        DBOperation dbInsertOperation = this.resolveSqlInsertAssociation(ctx.repositoryType, ctx.dialect, runtimeAssociation, persistentEntity, value);
        try {
            new JdbcEntityOperations(ctx, childPersistentEntity, child, dbInsertOperation).execute();
        }
        catch (Exception e) {
            throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    public void persistManyAssociationBatch(JdbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Iterable<Object> child, RuntimePersistentEntity<Object> childPersistentEntity) {
        DBOperation dbInsertOperation = this.resolveSqlInsertAssociation(ctx.repositoryType, ctx.dialect, runtimeAssociation, persistentEntity, value);
        try {
            JdbcEntitiesOperations assocOp = new JdbcEntitiesOperations(ctx, childPersistentEntity, child, dbInsertOperation);
            assocOp.veto(ctx.persisted::contains);
            assocOp.execute();
        }
        catch (Exception e) {
            throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    protected ConversionContext createTypeConversionContext(Connection connection, RuntimePersistentProperty<?> property, Argument<?> argument) {
        Objects.requireNonNull(connection);
        if (property != null) {
            return new RuntimePersistentPropertyJdbcCC(connection, property);
        }
        if (argument != null) {
            return new ArgumentJdbcCC(connection, argument);
        }
        return new JdbcConversionContextImpl(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            DefaultJdbcRepositoryOperations defaultJdbcRepositoryOperations = this;
            synchronized (defaultJdbcRepositoryOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async(), this.conversionService);
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.executeRead(connection -> {
            RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
            try (PreparedStatement ps = (PreparedStatement)this.prepareStatement(connection, connection::prepareStatement, preparedQuery, false, true);
                 ResultSet rs = ps.executeQuery();){
                Class resultType = preparedQuery.getResultType();
                if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                    RuntimePersistentEntity resultPersistentEntity = this.getEntity(resultType);
                    Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                    SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(resultPersistentEntity, this.columnNameResultSetReader, joinFetchPaths, this.jsonCodec, (loadedEntity, o) -> {
                        if (loadedEntity.hasPostLoadEventListeners()) {
                            return this.triggerPostLoad(o, (RuntimePersistentEntity)loadedEntity, preparedQuery.getAnnotationMetadata());
                        }
                        return o;
                    }, this.conversionService);
                    SqlResultEntityTypeMapper.PushingMapper oneMapper = mapper.readOneWithJoins();
                    if (rs.next()) {
                        oneMapper.processRow((Object)rs);
                    }
                    while (!joinFetchPaths.isEmpty() && rs.next()) {
                        oneMapper.processRow((Object)rs);
                    }
                    Object result = oneMapper.getResult();
                    if (preparedQuery.hasResultConsumer()) {
                        preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).ifPresent(consumer -> consumer.accept(result, this.newMappingContext(rs)));
                    }
                    Object object = result;
                    return object;
                }
                if (!rs.next()) return null;
                if (preparedQuery.isDtoProjection()) {
                    DTOMapper introspectedDataMapper = new DTOMapper(persistentEntity, this.columnNameResultSetReader, this.jsonCodec, this.conversionService);
                    Object object = introspectedDataMapper.map((Object)rs, resultType);
                    return object;
                }
                Object v = this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                if (v == null) {
                    Object var10_19 = null;
                    return var10_19;
                }
                if (resultType.isInstance(v)) {
                    Object object = v;
                    return object;
                }
                Object object = this.columnIndexResultSetReader.convertRequired(v, resultType);
                return object;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL Query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.executeRead(connection -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.findStream(preparedQuery, this.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, R> Stream<R> findStream(final @NonNull PreparedQuery<T, R> preparedQuery, Connection connection) {
        PreparedStatement ps;
        final Class resultType = preparedQuery.getResultType();
        final AtomicBoolean finished = new AtomicBoolean();
        try {
            ps = (PreparedStatement)this.prepareStatement(connection, connection::prepareStatement, preparedQuery, false, false);
        }
        catch (Exception e) {
            throw new DataAccessException("SQL Error preparing Query: " + e.getMessage(), (Throwable)e);
        }
        ResultSet openedRs = null;
        try {
            SqlDTOMapper mapper;
            Spliterators.AbstractSpliterator spliterator;
            boolean isEntity;
            final ResultSet rs = openedRs = ps.executeQuery();
            boolean dtoProjection = preparedQuery.isDtoProjection();
            boolean bl = isEntity = preparedQuery.getResultDataType() == DataType.ENTITY;
            if (!isEntity && !dtoProjection) {
                spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                    @Override
                    public boolean tryAdvance(Consumer<? super R> action) {
                        if (finished.get()) {
                            return false;
                        }
                        try {
                            boolean hasNext = rs.next();
                            if (hasNext) {
                                Object r;
                                Object v = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                                if (resultType.isInstance(v)) {
                                    action.accept(v);
                                } else if (v != null && (r = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType)) != null) {
                                    action.accept(r);
                                }
                            } else {
                                DefaultJdbcRepositoryOperations.this.closeResultSet(ps, rs, finished);
                            }
                            return hasNext;
                        }
                        catch (SQLException e) {
                            throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                        }
                    }
                };
                return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(ps, rs, finished));
            }
            SqlResultConsumer sqlMappingConsumer = preparedQuery.hasResultConsumer() ? (SqlResultConsumer)preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).orElse(null) : null;
            RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
            if (dtoProjection) {
                boolean isRawQuery = preparedQuery.getAnnotationMetadata().stringValue(Query.class, "rawQuery").isPresent();
                mapper = new SqlDTOMapper(persistentEntity, isRawQuery ? this.getEntity(preparedQuery.getResultType()) : persistentEntity, this.columnNameResultSetReader, this.jsonCodec, this.conversionService);
            } else {
                Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                SqlResultEntityTypeMapper entityTypeMapper = new SqlResultEntityTypeMapper(this.getEntity(resultType), this.columnNameResultSetReader, joinFetchPaths, this.jsonCodec, (loadedEntity, o) -> {
                    if (loadedEntity.hasPostLoadEventListeners()) {
                        return this.triggerPostLoad(o, (RuntimePersistentEntity)loadedEntity, preparedQuery.getAnnotationMetadata());
                    }
                    return o;
                }, this.conversionService);
                boolean onlySingleEndedJoins = this.isOnlySingleEndedJoins(persistentEntity, joinFetchPaths);
                if (!onlySingleEndedJoins) {
                    try {
                        SqlResultEntityTypeMapper.PushingMapper manyMapper = entityTypeMapper.readAllWithJoins();
                        while (rs.next()) {
                            manyMapper.processRow((Object)rs);
                        }
                        Stream stream = ((List)manyMapper.getResult()).stream();
                        return stream;
                    }
                    finally {
                        this.closeResultSet(ps, rs, finished);
                    }
                }
                mapper = entityTypeMapper;
            }
            spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040, (SqlTypeMapper)mapper, rs, resultType, sqlMappingConsumer, ps){
                final /* synthetic */ SqlTypeMapper val$mapper;
                final /* synthetic */ ResultSet val$rs;
                final /* synthetic */ Class val$resultType;
                final /* synthetic */ SqlResultConsumer val$sqlMappingConsumer;
                final /* synthetic */ PreparedStatement val$ps;
                {
                    this.val$mapper = sqlTypeMapper;
                    this.val$rs = resultSet;
                    this.val$resultType = clazz;
                    this.val$sqlMappingConsumer = sqlResultConsumer;
                    this.val$ps = preparedStatement;
                    super(x0, x1);
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (finished.get()) {
                        return false;
                    }
                    boolean hasNext = this.val$mapper.hasNext((Object)this.val$rs);
                    if (hasNext) {
                        Object o = this.val$mapper.map((Object)this.val$rs, this.val$resultType);
                        if (this.val$sqlMappingConsumer != null) {
                            this.val$sqlMappingConsumer.accept(this.val$rs, o);
                        }
                        action.accept(o);
                    } else {
                        DefaultJdbcRepositoryOperations.this.closeResultSet(this.val$ps, this.val$rs, finished);
                    }
                    return hasNext;
                }
            };
            return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(ps, rs, finished));
        }
        catch (Exception e) {
            this.closeResultSet(ps, openedRs, finished);
            throw new DataAccessException("SQL Error executing Query: " + e.getMessage(), (Throwable)e);
        }
    }

    private void closeResultSet(PreparedStatement ps, ResultSet rs, AtomicBoolean finished) {
        if (finished.compareAndSet(false, true)) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error closing JDBC result stream: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.executeRead(connection -> {
            try (Stream stream = this.findStream(preparedQuery, (Connection)connection);){
                List list = stream.collect(Collectors.toList());
                return list;
            }
        });
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.executeWrite(connection -> {
            try (PreparedStatement ps = (PreparedStatement)this.prepareStatement(connection, connection::prepareStatement, preparedQuery, true, false);){
                int result = ps.executeUpdate();
                if (QUERY_LOG.isTraceEnabled()) {
                    QUERY_LOG.trace("Update operation updated {} records", (Object)result);
                }
                if (preparedQuery.isOptimisticLock()) {
                    this.checkOptimisticLocking(1, result);
                }
                Optional<Integer> optional = Optional.of(result);
                return optional;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private Integer sum(Stream<Integer> stream) {
        return stream.mapToInt(i -> i).sum();
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return Optional.ofNullable(this.executeWrite(connection -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
            JdbcOperationContext ctx = new JdbcOperationContext(operation.getAnnotationMetadata(), operation.getRepositoryType(), queryBuilder.dialect(), (Connection)connection);
            Dialect dialect = queryBuilder.dialect();
            RuntimePersistentEntity persistentEntity = this.getEntity(operation.getRootEntity());
            if (this.isSupportsBatchDelete((PersistentEntity)persistentEntity, dialect)) {
                StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                JdbcEntitiesOperations op = new JdbcEntitiesOperations(ctx, this.getEntity(operation.getRootEntity()), (Iterable)operation, (DBOperation)dbOperation);
                op.delete();
                return op.rowsUpdated;
            }
            return this.sum(operation.split().stream().map(deleteOp -> {
                StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                JdbcEntityOperations op = new JdbcEntityOperations(ctx, this.getEntity(deleteOp.getRootEntity()), deleteOp.getEntity(), (DBOperation)dbOperation);
                op.delete();
                return op.rowsUpdated;
            }));
        }));
    }

    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
        return this.executeWrite(connection -> {
            JdbcOperationContext ctx = new JdbcOperationContext(operation.getAnnotationMetadata(), operation.getRepositoryType(), queryBuilder.dialect(), (Connection)connection);
            StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
            JdbcEntityOperations op = new JdbcEntityOperations(ctx, this.getEntity(operation.getRootEntity()), operation.getEntity(), (DBOperation)dbOperation);
            op.delete();
            return op;
        }).rowsUpdated;
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        Class repositoryType = operation.getRepositoryType();
        SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
        StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
        return (T)this.executeWrite(arg_0 -> this.lambda$update$12(annotationMetadata, repositoryType, queryBuilder, operation, (DBOperation)dbOperation, arg_0));
    }

    @NonNull
    public <T> Iterable<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        return this.executeWrite(connection -> {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            Class repositoryType = operation.getRepositoryType();
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            RuntimePersistentEntity persistentEntity = this.getEntity(operation.getRootEntity());
            StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
            JdbcOperationContext ctx = new JdbcOperationContext(annotationMetadata, repositoryType, queryBuilder.dialect(), (Connection)connection);
            if (!this.isSupportsBatchUpdate((PersistentEntity)persistentEntity, queryBuilder.dialect())) {
                return operation.split().stream().map(arg_0 -> this.lambda$null$13(ctx, persistentEntity, (DBOperation)dbOperation, arg_0)).collect(Collectors.toList());
            }
            JdbcEntitiesOperations op = new JdbcEntitiesOperations(ctx, persistentEntity, (Iterable)operation, (DBOperation)dbOperation);
            op.update();
            return op.getEntities();
        });
    }

    @NonNull
    public <T> T persist(@NonNull InsertOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        Class repositoryType = operation.getRepositoryType();
        SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
        return (T)this.executeWrite(connection -> {
            JdbcOperationContext ctx = new JdbcOperationContext(annotationMetadata, repositoryType, queryBuilder.dialect(), (Connection)connection);
            JdbcEntityOperations op = new JdbcEntityOperations(ctx, (DBOperation)new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery()), this.getEntity(operation.getRootEntity()), operation.getEntity(), true);
            op.persist();
            return op;
        }).getEntity();
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findStream method without an explicit query is not supported. Use findStream(PreparedQuery) instead");
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        throw new UnsupportedOperationException("The findPage method without an explicit query is not supported. Use findPage(PreparedQuery) instead");
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return this.executeWrite(connection -> {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            Class repositoryType = operation.getRepositoryType();
            SqlQueryBuilder sqlQueryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(sqlQueryBuilder, operation.getStoredQuery());
            RuntimePersistentEntity persistentEntity = this.getEntity(operation.getRootEntity());
            JdbcOperationContext ctx = new JdbcOperationContext(annotationMetadata, repositoryType, sqlQueryBuilder.dialect(), (Connection)connection);
            if (!this.isSupportsBatchInsert((PersistentEntity)persistentEntity, sqlQueryBuilder.dialect())) {
                return operation.split().stream().map(arg_0 -> this.lambda$null$16(ctx, (DBOperation)dbOperation, persistentEntity, arg_0)).collect(Collectors.toList());
            }
            JdbcEntitiesOperations op = new JdbcEntitiesOperations(ctx, persistentEntity, (Iterable)operation, (DBOperation)dbOperation, true);
            op.persist();
            return op.getEntities();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <I> I executeRead(Function<Connection, I> fn) {
        if (this.jdbcConfiguration.isTransactionPerOperation()) {
            return (I)this.transactionOperations.executeRead(status -> fn.apply((Connection)status.getConnection()));
        }
        if (!this.jdbcConfiguration.isAllowConnectionPerOperation()) return fn.apply((Connection)this.transactionOperations.getConnection());
        if (this.transactionOperations.hasConnection()) {
            return fn.apply((Connection)this.transactionOperations.getConnection());
        }
        try (Connection connection = this.unwrapedDataSource.getConnection();){
            I i = fn.apply(connection);
            return i;
        }
        catch (SQLException e) {
            throw new DataAccessException("Cannot get connection: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <I> I executeWrite(Function<Connection, I> fn) {
        if (this.jdbcConfiguration.isTransactionPerOperation()) {
            return (I)this.transactionOperations.executeWrite(status -> fn.apply((Connection)status.getConnection()));
        }
        if (!this.jdbcConfiguration.isAllowConnectionPerOperation()) return fn.apply((Connection)this.transactionOperations.getConnection());
        if (this.transactionOperations.hasConnection()) {
            return fn.apply((Connection)this.transactionOperations.getConnection());
        }
        try (Connection connection = this.unwrapedDataSource.getConnection();){
            I i = fn.apply(connection);
            return i;
        }
        catch (SQLException e) {
            throw new DataAccessException("Cannot get connection: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NonNull
    public Connection getConnection() {
        if (this.jdbcConfiguration.isTransactionPerOperation() || !this.jdbcConfiguration.isAllowConnectionPerOperation() || this.transactionOperations.hasConnection()) {
            return (Connection)this.transactionOperations.getConnection();
        }
        return DataSourceUtils.getConnection((DataSource)this.dataSource, (boolean)true);
    }

    @Override
    @NonNull
    public <R> R execute(@NonNull ConnectionCallback<R> callback) {
        try {
            return callback.call(this.getConnection());
        }
        catch (SQLException e) {
            throw new DataAccessException("Error executing SQL Callback: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public <R> R prepareStatement(@NonNull String sql, @NonNull PreparedStatementCallback<R> callback) {
        ArgumentUtils.requireNonNull((String)"sql", (Object)sql);
        ArgumentUtils.requireNonNull((String)"callback", callback);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)sql);
        }
        try {
            R result = null;
            PreparedStatement ps = this.getConnection().prepareStatement(sql);
            try {
                R r = result = (R)callback.call(ps);
                return r;
            }
            finally {
                if (!(result instanceof AutoCloseable)) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DataAccessException("Error preparing SQL statement: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @NonNull Class<T> rootEntity) {
        return this.entityStream(resultSet, null, rootEntity);
    }

    @Override
    @NonNull
    public <E> E readEntity(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> type) throws DataAccessException {
        return (E)new SqlResultEntityTypeMapper(prefix, this.getEntity(type), this.columnNameResultSetReader, this.jsonCodec, this.conversionService).map((Object)resultSet, type);
    }

    @Override
    @NonNull
    public <E, D> D readDTO(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
        return (D)new DTOMapper(this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec, this.conversionService).map((Object)resultSet, dtoType);
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @Nullable String prefix, @NonNull Class<T> rootEntity) {
        ArgumentUtils.requireNonNull((String)"resultSet", (Object)resultSet);
        ArgumentUtils.requireNonNull((String)"rootEntity", rootEntity);
        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec, this.conversionService);
        Iterable iterable = () -> this.lambda$entityStream$20(resultSet, (TypeMapper)mapper, rootEntity);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @NonNull
    private ResultConsumer.Context<ResultSet> newMappingContext(final ResultSet rs) {
        return new ResultConsumer.Context<ResultSet>(){

            public ResultSet getResultSet() {
                return rs;
            }

            public ResultReader<ResultSet, String> getResultReader() {
                return DefaultJdbcRepositoryOperations.this.columnNameResultSetReader;
            }

            @NonNull
            public <E> E readEntity(String prefix, Class<E> type) throws DataAccessException {
                RuntimePersistentEntity entity = DefaultJdbcRepositoryOperations.this.getEntity(type);
                SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec, DefaultJdbcRepositoryOperations.this.conversionService);
                return (E)mapper.map((Object)rs, type);
            }

            @NonNull
            public <E, D> D readDTO(@NonNull String prefix, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
                RuntimePersistentEntity entity = DefaultJdbcRepositoryOperations.this.getEntity(rootEntity);
                DTOMapper introspectedDataMapper = new DTOMapper(entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec, DefaultJdbcRepositoryOperations.this.conversionService);
                return (D)introspectedDataMapper.map((Object)rs, dtoType);
            }
        };
    }

    public boolean isSupportsBatchInsert(JdbcOperationContext jdbcOperationContext, RuntimePersistentEntity<?> persistentEntity) {
        return this.isSupportsBatchInsert((PersistentEntity)persistentEntity, jdbcOperationContext.dialect);
    }

    private /* synthetic */ Iterator lambda$entityStream$20(final ResultSet resultSet, final TypeMapper mapper, final Class rootEntity) {
        return new Iterator<T>(){
            boolean fetched = false;
            boolean end = false;

            @Override
            public boolean hasNext() {
                if (this.fetched) {
                    return true;
                }
                if (this.end) {
                    return false;
                }
                try {
                    if (resultSet.next()) {
                        this.fetched = true;
                    } else {
                        this.end = true;
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                }
                return !this.end;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.fetched = false;
                return mapper.map((Object)resultSet, rootEntity);
            }
        };
    }

    private /* synthetic */ Object lambda$null$16(JdbcOperationContext ctx, DBOperation dbOperation, RuntimePersistentEntity persistentEntity, InsertOperation persistOp) {
        JdbcEntityOperations op = new JdbcEntityOperations(ctx, dbOperation, persistentEntity, persistOp.getEntity(), true);
        op.persist();
        return op.getEntity();
    }

    private /* synthetic */ Object lambda$null$13(JdbcOperationContext ctx, RuntimePersistentEntity persistentEntity, DBOperation dbOperation, UpdateOperation updateOp) {
        JdbcEntityOperations op = new JdbcEntityOperations(ctx, persistentEntity, updateOp.getEntity(), dbOperation);
        op.update();
        return op.getEntity();
    }

    private /* synthetic */ Object lambda$update$12(AnnotationMetadata annotationMetadata, Class repositoryType, SqlQueryBuilder queryBuilder, UpdateOperation operation, DBOperation dbOperation, Connection connection) {
        JdbcOperationContext ctx = new JdbcOperationContext(annotationMetadata, repositoryType, queryBuilder.dialect(), connection);
        JdbcEntityOperations op = new JdbcEntityOperations(ctx, this.getEntity(operation.getRootEntity()), operation.getEntity(), dbOperation);
        op.update();
        return op.getEntity();
    }

    private static class JdbcConversionContextImpl
    extends AbstractConversionContext
    implements JdbcConversionContext {
        private final Connection connection;

        public JdbcConversionContextImpl(Connection connection) {
            this(ConversionContext.DEFAULT, connection);
        }

        public JdbcConversionContextImpl(ConversionContext conversionContext, Connection connection) {
            super(conversionContext);
            this.connection = connection;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }
    }

    private static final class ArgumentJdbcCC
    extends JdbcConversionContextImpl
    implements ArgumentConversionContext<Object> {
        private final Argument argument;

        public ArgumentJdbcCC(Connection connection, Argument argument) {
            super((ConversionContext)ConversionContext.of((Argument)argument), connection);
            this.argument = argument;
        }

        public Argument<Object> getArgument() {
            return this.argument;
        }
    }

    private static final class RuntimePersistentPropertyJdbcCC
    extends JdbcConversionContextImpl
    implements RuntimePersistentPropertyConversionContext {
        private final RuntimePersistentProperty<?> property;

        public RuntimePersistentPropertyJdbcCC(Connection connection, RuntimePersistentProperty<?> property) {
            super((ConversionContext)ConversionContext.of((Argument)property.getArgument()), connection);
            this.property = property;
        }

        public RuntimePersistentProperty<?> getRuntimePersistentProperty() {
            return this.property;
        }
    }

    protected static class JdbcOperationContext
    extends OperationContext {
        public final Connection connection;
        public final Dialect dialect;

        public JdbcOperationContext(AnnotationMetadata annotationMetadata, Class<?> repositoryType, Dialect dialect, Connection connection) {
            super(annotationMetadata, repositoryType);
            this.dialect = dialect;
            this.connection = connection;
        }
    }

    private final class JdbcEntitiesOperations<T>
    extends AbstractSyncEntitiesOperations<JdbcOperationContext, T, SQLException> {
        private final DBOperation dbOperation;
        private int rowsUpdated;

        private JdbcEntitiesOperations(JdbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, DBOperation dbOperation) {
            this(ctx, persistentEntity, entities, dbOperation, false);
        }

        private JdbcEntitiesOperations(JdbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, DBOperation dbOperation, boolean insert) {
            super((OperationContext)ctx, DefaultJdbcRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultJdbcRepositoryOperations.this.conversionService, DefaultJdbcRepositoryOperations.this.entityEventRegistry, persistentEntity, entities, insert);
            this.dbOperation = dbOperation;
        }

        protected void collectAutoPopulatedPreviousValues() {
            for (AbstractSyncEntitiesOperations.Data d : this.entities) {
                if (d.vetoed) continue;
                d.previousValues = this.dbOperation.collectAutoPopulatedPreviousValues(this.persistentEntity, d.entity);
            }
        }

        private PreparedStatement prepare(Connection connection) throws SQLException {
            if (this.insert) {
                Dialect dialect = this.dbOperation.getDialect();
                if (this.hasGeneratedId && (dialect == Dialect.ORACLE || dialect == Dialect.SQL_SERVER)) {
                    return connection.prepareStatement(this.dbOperation.getQuery(), new String[]{this.persistentEntity.getIdentity().getPersistedName()});
                }
                return connection.prepareStatement(this.dbOperation.getQuery(), this.hasGeneratedId ? 1 : 2);
            }
            return connection.prepareStatement(this.dbOperation.getQuery());
        }

        private void setParameters(OpContext<Connection, PreparedStatement> context, Connection connection, PreparedStatement stmt, DBOperation sqlOperation) throws SQLException {
            for (AbstractSyncEntitiesOperations.Data d : this.entities) {
                if (d.vetoed) continue;
                sqlOperation.setParameters(context, (Object)connection, (Object)stmt, this.persistentEntity, d.entity, d.previousValues);
                stmt.addBatch();
            }
        }

        protected void execute() throws SQLException {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL query: {}", (Object)this.dbOperation.getQuery());
            }
            try (PreparedStatement ps = this.prepare(((JdbcOperationContext)this.ctx).connection);){
                this.setParameters((OpContext<Connection, PreparedStatement>)DefaultJdbcRepositoryOperations.this, ((JdbcOperationContext)this.ctx).connection, ps, this.dbOperation);
                this.rowsUpdated = Arrays.stream(ps.executeBatch()).sum();
                if (this.hasGeneratedId) {
                    RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                    ArrayList<Object> ids = new ArrayList<Object>();
                    ResultSet generatedKeys = ps.getGeneratedKeys();
                    Object object = null;
                    try {
                        while (generatedKeys.next()) {
                            ids.add(DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)generatedKeys, (Object)1, identity.getDataType()));
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (generatedKeys != null) {
                            if (object != null) {
                                try {
                                    generatedKeys.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                generatedKeys.close();
                            }
                        }
                    }
                    Iterator iterator = ids.iterator();
                    for (AbstractSyncEntitiesOperations.Data d2 : this.entities) {
                        if (d2.vetoed) continue;
                        if (!iterator.hasNext()) {
                            throw new DataAccessException("Failed to generate ID for entity: " + d2.entity);
                        }
                        Object id = iterator.next();
                        d2.entity = this.updateEntityId(identity.getProperty(), d2.entity, id);
                    }
                }
                if (this.dbOperation.isOptimisticLock()) {
                    int expected = (int)this.entities.stream().filter(d -> !d.vetoed).count();
                    this.checkOptimisticLocking(expected, this.rowsUpdated);
                }
            }
        }
    }

    private final class JdbcEntityOperations<T>
    extends AbstractSyncEntityOperations<JdbcOperationContext, T, SQLException> {
        private final DBOperation dbOperation;
        private Integer rowsUpdated;
        private Map<QueryParameterBinding, Object> previousValues;

        private JdbcEntityOperations(JdbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, DBOperation dbOperation) {
            this(ctx, dbOperation, persistentEntity, entity, false);
        }

        private JdbcEntityOperations(JdbcOperationContext ctx, DBOperation dbOperation, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
            super((OperationContext)ctx, DefaultJdbcRepositoryOperations.this.cascadeOperations, DefaultJdbcRepositoryOperations.this.entityEventRegistry, persistentEntity, (ConversionService)DefaultJdbcRepositoryOperations.this.conversionService, entity, insert);
            this.dbOperation = dbOperation;
        }

        protected void collectAutoPopulatedPreviousValues() {
            this.previousValues = this.dbOperation.collectAutoPopulatedPreviousValues(this.persistentEntity, this.entity);
        }

        private PreparedStatement prepare(Connection connection, DBOperation dbOperation) throws SQLException {
            if (StoredSqlOperation.class.isInstance(dbOperation)) {
                ((StoredSqlOperation)dbOperation).checkForParameterToBeExpanded(this.persistentEntity, this.entity);
            }
            if (this.insert) {
                StoredSqlOperation sqlOperation = (StoredSqlOperation)dbOperation;
                Dialect dialect = sqlOperation.getDialect();
                if (this.hasGeneratedId && (dialect == Dialect.ORACLE || dialect == Dialect.SQL_SERVER)) {
                    return connection.prepareStatement(dbOperation.getQuery(), new String[]{this.persistentEntity.getIdentity().getPersistedName()});
                }
                return connection.prepareStatement(dbOperation.getQuery(), this.hasGeneratedId ? 1 : 2);
            }
            return connection.prepareStatement(dbOperation.getQuery());
        }

        protected void execute() throws SQLException {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL query: {}", (Object)this.dbOperation.getQuery());
            }
            try (PreparedStatement ps = this.prepare(((JdbcOperationContext)this.ctx).connection, this.dbOperation);){
                block28: {
                    this.dbOperation.setParameters((OpContext)DefaultJdbcRepositoryOperations.this, (Object)((JdbcOperationContext)this.ctx).connection, (Object)ps, this.persistentEntity, this.entity, this.previousValues);
                    this.rowsUpdated = ps.executeUpdate();
                    if (this.hasGeneratedId) {
                        try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                            if (generatedKeys.next()) {
                                RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                                Object id = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)generatedKeys, (Object)1, identity.getDataType());
                                BeanProperty property = identity.getProperty();
                                this.entity = this.updateEntityId(property, this.entity, id);
                                break block28;
                            }
                            throw new DataAccessException("Failed to generate ID for entity: " + this.entity);
                        }
                    }
                }
                if (this.dbOperation.isOptimisticLock()) {
                    this.checkOptimisticLocking(1L, this.rowsUpdated.intValue());
                }
            }
        }
    }
}

