/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.runtime;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.runtime.ConnectionCallback;
import io.micronaut.data.jdbc.runtime.PreparedStatementCallback;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.stream.Stream;
import javax.sql.DataSource;

public interface JdbcOperations {
    @NonNull
    public DataSource getDataSource();

    @NonNull
    public Connection getConnection();

    @NonNull
    public <R> R execute(@NonNull ConnectionCallback<R> var1);

    @NonNull
    public <R> R prepareStatement(@NonNull String var1, @NonNull PreparedStatementCallback<R> var2);

    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet var1, @Nullable String var2, @NonNull Class<T> var3);

    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet var1, @NonNull Class<T> var2);

    @NonNull
    public <E> E readEntity(@NonNull String var1, @NonNull ResultSet var2, @NonNull Class<E> var3) throws DataAccessException;

    @NonNull
    default public <E> E readEntity(@NonNull ResultSet resultSet, @NonNull Class<E> type) throws DataAccessException {
        return this.readEntity("", resultSet, type);
    }

    @NonNull
    public <E, D> D readDTO(@NonNull String var1, @NonNull ResultSet var2, @NonNull Class<E> var3, @NonNull Class<D> var4) throws DataAccessException;

    @NonNull
    default public <E, D> D readDTO(@NonNull ResultSet resultSet, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
        return this.readDTO("", resultSet, rootEntity, dtoType);
    }
}

