/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.DateUpdated;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.jdbc.annotation.JdbcRepository;
import io.micronaut.data.jdbc.mapper.ColumnIndexResultSetReader;
import io.micronaut.data.jdbc.mapper.ColumnNameResultSetReader;
import io.micronaut.data.jdbc.mapper.JdbcQueryStatement;
import io.micronaut.data.jdbc.mapper.SqlResultConsumer;
import io.micronaut.data.jdbc.operations.AbstractSqlRepositoryOperations;
import io.micronaut.data.jdbc.operations.JdbcRepositoryOperations;
import io.micronaut.data.jdbc.runtime.ConnectionCallback;
import io.micronaut.data.jdbc.runtime.PreparedStatementCallback;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.DTOMapper;
import io.micronaut.data.runtime.mapper.ResultConsumer;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.TransactionOperations;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.sql.DataSource;

@EachBean(value=DataSource.class)
public class DefaultJdbcRepositoryOperations
extends AbstractSqlRepositoryOperations<ResultSet, PreparedStatement>
implements JdbcRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
AutoCloseable {
    private static final Object IGNORED_PARAMETER = new Object();
    private final TransactionOperations<Connection> transactionOperations;
    private final DataSource dataSource;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    protected DefaultJdbcRepositoryOperations(@Parameter String dataSourceName, DataSource dataSource, @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, BeanContext beanContext, List<MediaTypeCodec> codecs, @NonNull DateTimeProvider dateTimeProvider) {
        super(new ColumnNameResultSetReader(), new ColumnIndexResultSetReader(), new JdbcQueryStatement(), codecs, dateTimeProvider);
        ArgumentUtils.requireNonNull((String)"dataSource", (Object)dataSource);
        ArgumentUtils.requireNonNull((String)"transactionOperations", transactionOperations);
        this.dataSource = dataSource;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
        Collection beanDefinitions = beanContext.getBeanDefinitions(GenericRepository.class, Qualifiers.byStereotype(Repository.class));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String targetDs = beanDefinition.stringValue(Repository.class).orElse("default");
            if (!targetDs.equalsIgnoreCase(dataSourceName)) continue;
            Dialect dialect = beanDefinition.enumValue(JdbcRepository.class, "dialect", Dialect.class).orElseGet(() -> beanDefinition.enumValue(JdbcRepository.class, "dialectName", Dialect.class).orElse(Dialect.ANSI));
            this.dialects.put(beanDefinition.getBeanType(), dialect);
            QueryBuilder qb = (QueryBuilder)this.queryBuilders.get(dialect);
            if (qb != null) continue;
            this.queryBuilders.put(dialect, new SqlQueryBuilder(dialect));
        }
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            DefaultJdbcRepositoryOperations defaultJdbcRepositoryOperations = this;
            synchronized (defaultJdbcRepositoryOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async());
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            try (PreparedStatement ps = this.prepareStatement(connection, preparedQuery, false, true);
                 ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                Class resultType = preparedQuery.getResultType();
                if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                    RuntimePersistentEntity persistentEntity = this.getEntity(resultType);
                    SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(persistentEntity, this.columnNameResultSetReader, preparedQuery.getJoinFetchPaths(), this.jsonCodec);
                    Object result = mapper.map((Object)rs, resultType);
                    if (preparedQuery.hasResultConsumer()) {
                        preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).ifPresent(consumer -> consumer.accept(result, this.newMappingContext(rs)));
                    }
                    Object object = result;
                    return object;
                }
                if (preparedQuery.isDtoProjection()) {
                    RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
                    DTOMapper introspectedDataMapper = new DTOMapper(persistentEntity, this.columnNameResultSetReader, this.jsonCodec);
                    Object object = introspectedDataMapper.map((Object)rs, resultType);
                    return object;
                }
                Object v = this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                if (v == null) {
                    Object var10_19 = null;
                    return var10_19;
                }
                if (resultType.isInstance(v)) {
                    Object object = v;
                    return object;
                }
                Object object = this.columnIndexResultSetReader.convertRequired(v, resultType);
                return object;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL Query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @NonNull
    private ResultConsumer.Context<ResultSet> newMappingContext(final ResultSet rs) {
        return new ResultConsumer.Context<ResultSet>(){

            public ResultSet getResultSet() {
                return rs;
            }

            public ResultReader<ResultSet, String> getResultReader() {
                return DefaultJdbcRepositoryOperations.this.columnNameResultSetReader;
            }

            @NonNull
            public <E> E readEntity(String prefix, Class<E> type) throws DataAccessException {
                RuntimePersistentEntity<E> entity = DefaultJdbcRepositoryOperations.this.getEntity(type);
                SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec);
                return (E)mapper.map((Object)rs, type);
            }

            @NonNull
            public <E, D> D readDTO(@NonNull String prefix, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
                RuntimePersistentEntity<E> entity = DefaultJdbcRepositoryOperations.this.getEntity(rootEntity);
                DTOMapper introspectedDataMapper = new DTOMapper(entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec);
                return (D)introspectedDataMapper.map((Object)rs, dtoType);
            }
        };
    }

    public <T, R> boolean exists(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Boolean)this.transactionOperations.executeRead(status -> {
            try {
                Connection connection = (Connection)status.getConnection();
                PreparedStatement ps = this.prepareStatement(connection, preparedQuery, false, true);
                ResultSet rs = ps.executeQuery();
                return rs.next();
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Stream)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            return this.findStream(preparedQuery, connection);
        });
    }

    private <T, R> Stream<R> findStream(final @NonNull PreparedQuery<T, R> preparedQuery, Connection connection) {
        Spliterators.AbstractSpliterator spliterator;
        ResultSet rs;
        PreparedStatement ps;
        final Class resultType = preparedQuery.getResultType();
        try {
            ps = this.prepareStatement(connection, preparedQuery, false, false);
        }
        catch (SQLException e) {
            throw new DataAccessException("SQL Error preparing Query: " + e.getMessage(), (Throwable)e);
        }
        try {
            rs = ps.executeQuery();
        }
        catch (SQLException e) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new DataAccessException("SQL Error executing Query: " + e.getMessage(), (Throwable)e);
        }
        boolean dtoProjection = preparedQuery.isDtoProjection();
        boolean isEntity = preparedQuery.getResultDataType() == DataType.ENTITY;
        final AtomicBoolean finished = new AtomicBoolean();
        if (isEntity || dtoProjection) {
            SqlResultConsumer sqlMappingConsumer = preparedQuery.hasResultConsumer() ? (SqlResultConsumer)preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).orElse(null) : null;
            Object mapper = dtoProjection ? new SqlDTOMapper(this.getEntity(resultType), this.columnNameResultSetReader, this.jsonCodec) : new SqlResultEntityTypeMapper(this.getEntity(resultType), this.columnNameResultSetReader, preparedQuery.getJoinFetchPaths(), this.jsonCodec);
            spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040, (SqlTypeMapper)mapper, rs, resultType, sqlMappingConsumer, ps){
                final /* synthetic */ SqlTypeMapper val$mapper;
                final /* synthetic */ ResultSet val$rs;
                final /* synthetic */ Class val$resultType;
                final /* synthetic */ SqlResultConsumer val$sqlMappingConsumer;
                final /* synthetic */ PreparedStatement val$ps;
                {
                    this.val$mapper = sqlTypeMapper;
                    this.val$rs = resultSet;
                    this.val$resultType = clazz;
                    this.val$sqlMappingConsumer = sqlResultConsumer;
                    this.val$ps = preparedStatement;
                    super(x0, x1);
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (finished.get()) {
                        return false;
                    }
                    boolean hasNext = this.val$mapper.hasNext((Object)this.val$rs);
                    if (hasNext) {
                        Object o = this.val$mapper.map((Object)this.val$rs, this.val$resultType);
                        if (this.val$sqlMappingConsumer != null) {
                            this.val$sqlMappingConsumer.accept(this.val$rs, o);
                        }
                        action.accept(o);
                    } else {
                        DefaultJdbcRepositoryOperations.this.closeResultSet(this.val$ps, this.val$rs, finished);
                    }
                    return hasNext;
                }
            };
        } else {
            spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (finished.get()) {
                        return false;
                    }
                    try {
                        boolean hasNext = rs.next();
                        if (hasNext) {
                            Object r;
                            Object v = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                            if (resultType.isInstance(v)) {
                                action.accept(v);
                            } else if (v != null && (r = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType)) != null) {
                                action.accept(r);
                            }
                        } else {
                            DefaultJdbcRepositoryOperations.this.closeResultSet(ps, rs, finished);
                        }
                        return hasNext;
                    }
                    catch (SQLException e) {
                        throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
        return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(ps, rs, finished));
    }

    private void closeResultSet(PreparedStatement ps, ResultSet rs, AtomicBoolean finished) {
        if (finished.compareAndSet(false, true)) {
            try {
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new DataAccessException("Error closing JDBC result stream: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            return this.findStream(preparedQuery, connection).collect(Collectors.toList());
        });
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return (Optional)this.transactionOperations.executeWrite(status -> {
            try {
                Connection connection = (Connection)status.getConnection();
                try (PreparedStatement ps = this.prepareStatement(connection, preparedQuery, true, false);){
                    int result = ps.executeUpdate();
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", (Object)result);
                    }
                    Optional<Integer> optional = Optional.of(result);
                    return optional;
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public <T> Optional<Number> deleteAll(@NonNull BatchOperation<T> operation) {
        throw new UnsupportedOperationException("The deleteAll method via batch is unsupported. Execute the SQL update directly");
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        String[] params = annotationMetadata.stringValues(DataMethod.class, "parameterBindingPaths");
        String query = annotationMetadata.stringValue(Query.class).orElse(null);
        Object entity = operation.getEntity();
        HashSet persisted = new HashSet(10);
        Class repositoryType = operation.getRepositoryType();
        return (T)this.updateOne(repositoryType, annotationMetadata, query, params, entity, persisted);
    }

    private <T> T updateOne(Class<?> repositoryType, AnnotationMetadata annotationMetadata, String query, String[] params, T entity, Set persisted) {
        Objects.requireNonNull(entity, "Passed entity cannot be null");
        if (StringUtils.isNotEmpty((CharSequence)query) && ArrayUtils.isNotEmpty((Object[])params)) {
            RuntimePersistentEntity<?> persistentEntity = this.getEntity(entity.getClass());
            return (T)this.transactionOperations.executeWrite(status -> {
                try {
                    Connection connection = (Connection)status.getConnection();
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing SQL UPDATE: {}", (Object)query);
                    }
                    try (PreparedStatement ps = connection.prepareStatement(query);){
                        for (int i = 0; i < params.length; ++i) {
                            Object newValue;
                            String propertyName = params[i];
                            RuntimePersistentProperty pp = persistentEntity.getPropertyByName(propertyName);
                            if (pp == null) {
                                Association assoc;
                                int j = propertyName.indexOf(46);
                                if (j <= -1) throw new IllegalStateException("Cannot perform update for non-existent property: " + persistentEntity.getSimpleName() + "." + propertyName);
                                RuntimePersistentProperty embeddedProp = persistentEntity.getPropertyByPath(propertyName).orElse(null);
                                if (embeddedProp == null) throw new IllegalStateException("Cannot perform update for non-existent property: " + persistentEntity.getSimpleName() + "." + propertyName);
                                pp = persistentEntity.getPropertyByName(propertyName.substring(0, j));
                                if (!(pp instanceof Association) || (assoc = (Association)pp).getKind() != Relation.Kind.EMBEDDED) continue;
                                Object embeddedInstance = pp.getProperty().get(entity);
                                Object embeddedValue = embeddedInstance != null ? embeddedProp.getProperty().get(embeddedInstance) : null;
                                int index = i + 1;
                                this.preparedStatementWriter.setDynamic((Object)ps, (Object)index, embeddedProp.getDataType(), embeddedValue);
                                continue;
                            }
                            BeanProperty beanProperty = pp.getProperty();
                            if (beanProperty.hasAnnotation(DateUpdated.class)) {
                                newValue = this.dateTimeProvider.getNow();
                                beanProperty.convertAndSet(entity, newValue);
                            } else {
                                newValue = beanProperty.get(entity);
                            }
                            DataType dataType = pp.getDataType();
                            if (dataType == DataType.ENTITY && newValue != null && pp instanceof Association) {
                                RuntimePersistentProperty<Object> idReader = this.getIdReader(newValue);
                                Association association = (Association)pp;
                                BeanProperty idReaderProperty = idReader.getProperty();
                                Object id = idReaderProperty.get(newValue);
                                if (QUERY_LOG.isTraceEnabled()) {
                                    QUERY_LOG.trace("Binding parameter at position {} to value {}", (Object)(i + 1), id);
                                }
                                if (id != null) {
                                    this.preparedStatementWriter.setDynamic((Object)ps, (Object)(i + 1), idReader.getDataType(), id);
                                    if (!association.doesCascade(new Relation.Cascade[]{Relation.Cascade.PERSIST}) || persisted.contains(newValue)) continue;
                                    Relation.Kind kind = association.getKind();
                                    RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
                                    switch (kind) {
                                        case ONE_TO_ONE: 
                                        case MANY_TO_ONE: {
                                            persisted.add(newValue);
                                            AbstractSqlRepositoryOperations.StoredInsert updateStatement = this.resolveEntityUpdate(annotationMetadata, repositoryType, associatedEntity.getIntrospection().getBeanType(), associatedEntity);
                                            this.updateOne(repositoryType, annotationMetadata, updateStatement.getSql(), updateStatement.getParameterBinding(), newValue, persisted);
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (!association.doesCascade(new Relation.Cascade[]{Relation.Cascade.PERSIST}) || persisted.contains(newValue)) continue;
                                RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
                                AbstractSqlRepositoryOperations.StoredInsert associatedInsert = this.resolveEntityInsert(annotationMetadata, repositoryType, associatedEntity.getIntrospection().getBeanType(), associatedEntity);
                                this.persistOne(annotationMetadata, repositoryType, associatedInsert, newValue, persisted);
                                Object assignedId = idReaderProperty.get(newValue);
                                if (assignedId == null) continue;
                                this.preparedStatementWriter.setDynamic((Object)ps, (Object)(i + 1), idReader.getDataType(), assignedId);
                                continue;
                            }
                            if (dataType == DataType.JSON && this.jsonCodec != null && newValue != null) {
                                String value = new String(this.jsonCodec.encode(newValue), StandardCharsets.UTF_8);
                                if (QUERY_LOG.isTraceEnabled()) {
                                    QUERY_LOG.trace("Binding parameter at position {} to value {}", (Object)(i + 1), (Object)value);
                                }
                                this.preparedStatementWriter.setDynamic((Object)ps, (Object)(i + 1), dataType, (Object)value);
                                continue;
                            }
                            if (QUERY_LOG.isTraceEnabled()) {
                                QUERY_LOG.trace("Binding parameter at position {} to value {}", (Object)(i + 1), newValue);
                            }
                            this.preparedStatementWriter.setDynamic((Object)ps, (Object)(i + 1), dataType, newValue);
                        }
                        ps.executeUpdate();
                        Object object = entity;
                        return object;
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
                }
            });
        }
        return entity;
    }

    @NonNull
    public <T> T persist(@NonNull InsertOperation<T> operation) {
        AbstractSqlRepositoryOperations.StoredInsert insert = this.resolveInsert(operation);
        Class repositoryType = operation.getRepositoryType();
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        Object entity = operation.getEntity();
        return (T)this.persistOne(annotationMetadata, repositoryType, insert, entity, new HashSet(5));
    }

    private <T> T persistOne(AnnotationMetadata annotationMetadata, Class<?> repositoryType, AbstractSqlRepositoryOperations.StoredInsert<T> insert, T entity, Set persisted) {
        return (T)this.transactionOperations.executeWrite(status -> {
            try {
                boolean hasGeneratedID;
                Connection connection = (Connection)status.getConnection();
                boolean generateId = insert.isGenerateId();
                String insertSql = insert.getSql();
                BeanProperty identity = insert.getIdentityProperty();
                boolean bl = hasGeneratedID = generateId && identity != null;
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing SQL Insert: {}", (Object)insertSql);
                }
                PreparedStatement stmt = hasGeneratedID && (insert.getDialect() == Dialect.ORACLE || insert.getDialect() == Dialect.SQL_SERVER) ? connection.prepareStatement(insertSql, new String[]{insert.getIdentity().getPersistedName()}) : connection.prepareStatement(insertSql, generateId ? 1 : 2);
                this.setInsertParameters(insert, entity, stmt);
                stmt.executeUpdate();
                persisted.add(entity);
                if (hasGeneratedID) {
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    if (generatedKeys.next()) {
                        Object id = this.getEntityId(generatedKeys, insert.getIdentity().getDataType(), identity.getType());
                        if (identity.getType().isInstance(id)) {
                            identity.set(entity, id);
                        } else {
                            identity.convertAndSet(entity, id);
                        }
                    } else {
                        throw new DataAccessException("ID failed to generate. No result returned.");
                    }
                }
                this.cascadeInserts(annotationMetadata, repositoryType, insert, entity, persisted, connection, identity);
                return entity;
            }
            catch (SQLException e) {
                throw new DataAccessException("SQL Error executing INSERT: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private <T> void cascadeInserts(AnnotationMetadata annotationMetadata, Class<?> repositoryType, AbstractSqlRepositoryOperations.StoredInsert<T> insert, T entity, Set persisted, Connection connection, BeanProperty<T, Object> identity) throws SQLException {
        if (identity != null) {
            RuntimePersistentEntity<?> persistentEntity = this.getEntity(entity.getClass());
            block12: for (RuntimeAssociation association : persistentEntity.getAssociations()) {
                Iterable batchResult;
                BeanProperty bp;
                AbstractSqlRepositoryOperations.StoredInsert associatedInsert;
                if (!association.doesCascade(new Relation.Cascade[]{Relation.Cascade.PERSIST})) continue;
                Relation.Kind kind = association.getKind();
                RuntimePersistentEntity associatedEntity = association.getAssociatedEntity();
                Class associationType = associatedEntity.getIntrospection().getBeanType();
                RuntimePersistentProperty associatedId = associatedEntity.getIdentity();
                BeanProperty associatedIdProperty = associatedId.getProperty();
                switch (kind) {
                    case ONE_TO_ONE: 
                    case MANY_TO_ONE: {
                        Object id;
                        Object associated = association.getProperty().get(entity);
                        if (associated == null || persisted.contains(associated)) continue block12;
                        if (association.isForeignKey()) {
                            association.getInverseSide().ifPresent(inverse -> {
                                BeanProperty property = inverse.getProperty();
                                property.set(associated, entity);
                            });
                        }
                        associatedInsert = this.resolveEntityInsert(annotationMetadata, repositoryType, associationType, associatedEntity);
                        if (associatedId != null && (id = associatedIdProperty.get(associated)) != null) continue block12;
                        this.persistOne(annotationMetadata, repositoryType, associatedInsert, associated, persisted);
                        continue block12;
                    }
                }
                Object many = association.getProperty().get(entity);
                RuntimeAssociation inverse2 = association.getInverseSide().orElse(null);
                associatedInsert = this.resolveEntityInsert(annotationMetadata, repositoryType, associationType, associatedEntity);
                if (!(many instanceof Iterable)) continue;
                Iterable entities = (Iterable)many;
                ArrayList toPersist = new ArrayList(15);
                for (Object o : entities) {
                    Object id;
                    if (o == null || persisted.contains(o)) continue;
                    if (inverse2 != null && inverse2.getKind() == Relation.Kind.MANY_TO_ONE) {
                        BeanProperty property = inverse2.getProperty();
                        property.set(o, entity);
                    }
                    if (associatedId == null || (id = (bp = associatedIdProperty).get(o)) != null) continue;
                    toPersist.add(o);
                }
                if (insert.doesSupportBatch()) {
                    batchResult = this.persistInBatch(annotationMetadata, repositoryType, toPersist, associatedInsert, persisted);
                } else {
                    ArrayList arrayList = new ArrayList(toPersist);
                    bp = toPersist.iterator();
                    while (bp.hasNext()) {
                        Object o = bp.next();
                        arrayList.add(this.persistOne(annotationMetadata, repositoryType, associatedInsert, o, persisted));
                    }
                    batchResult = arrayList;
                }
                if (!SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) continue;
                String associationInsert = this.resolveAssociationInsert(repositoryType, persistentEntity, association);
                PreparedStatement ps = connection.prepareStatement(associationInsert);
                Throwable throwable = null;
                try {
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing SQL Insert: {}", (Object)associationInsert);
                    }
                    Object parentId = identity.get(entity);
                    for (Object o : batchResult) {
                        Object childId = associatedIdProperty.get(o);
                        if (QUERY_LOG.isTraceEnabled()) {
                            QUERY_LOG.trace("Binding parameter at position {} to value {}", (Object)1, parentId);
                        }
                        this.preparedStatementWriter.setDynamic((Object)ps, (Object)1, persistentEntity.getIdentity().getDataType(), parentId);
                        if (QUERY_LOG.isTraceEnabled()) {
                            QUERY_LOG.trace("Binding parameter at position {} to value {}", (Object)2, childId);
                        }
                        this.preparedStatementWriter.setDynamic((Object)ps, (Object)2, associatedId.getDataType(), childId);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T, R> PreparedStatement prepareStatement(Connection connection, @NonNull PreparedQuery<T, R> preparedQuery, boolean isUpdate, boolean isSingleResult) throws SQLException {
        Pageable pageable;
        Object[] queryParameters = preparedQuery.getParameterArray();
        int[] parameterBinding = preparedQuery.getIndexedParameterBinding();
        DataType[] parameterTypes = preparedQuery.getIndexedParameterTypes();
        String query = preparedQuery.getQuery();
        Dialect dialect = this.dialects.getOrDefault(preparedQuery.getRepositoryType(), Dialect.ANSI);
        boolean hasIn = preparedQuery.hasInExpression();
        if (hasIn) {
            Matcher matcher = IN_EXPRESSION_PATTERN.matcher(query);
            while (matcher.find()) {
                int inIndex = Integer.valueOf(matcher.group(1));
                int queryParameterIndex = parameterBinding[inIndex - 1];
                Object value = queryParameters[queryParameterIndex];
                if (value == null) {
                    query = matcher.replaceFirst("1 = 2");
                    queryParameters[queryParameterIndex] = IGNORED_PARAMETER;
                } else {
                    int size = this.sizeOf(value);
                    if (size == 0) {
                        queryParameters[queryParameterIndex] = IGNORED_PARAMETER;
                        query = matcher.replaceFirst("1 = 2");
                    } else {
                        String replacement = " IN(" + String.join((CharSequence)",", Collections.nCopies(size, "?")) + ")";
                        query = matcher.replaceFirst(replacement);
                    }
                }
                matcher = IN_EXPRESSION_PATTERN.matcher(query);
            }
        }
        if (!isUpdate && (pageable = preparedQuery.getPageable()) != Pageable.UNPAGED) {
            Class rootEntity = preparedQuery.getRootEntity();
            Sort sort = pageable.getSort();
            QueryBuilder queryBuilder = (QueryBuilder)this.queryBuilders.getOrDefault(dialect, DEFAULT_SQL_BUILDER);
            if (sort.isSorted()) {
                query = query + queryBuilder.buildOrderBy(this.getEntity(rootEntity), sort).getQuery();
            } else if (this.isSqlServerWithoutOrderBy(query, dialect)) {
                RuntimePersistentEntity persistentEntity = this.getEntity(rootEntity);
                sort = this.sortById(persistentEntity);
                query = query + queryBuilder.buildOrderBy(persistentEntity, sort).getQuery();
            }
            if (isSingleResult && pageable.getOffset() > 0L) {
                pageable = Pageable.from((int)pageable.getNumber(), (int)1);
            }
            query = query + queryBuilder.buildPagination(pageable).getQuery();
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)query);
        }
        PreparedStatement ps = connection.prepareStatement(query);
        int index = 1;
        for (int i = 0; i < parameterBinding.length; ++i) {
            Object value;
            int parameterIndex = parameterBinding[i];
            DataType dataType = parameterTypes[i];
            if (parameterIndex > -1) {
                value = queryParameters[parameterIndex];
            } else {
                String[] indexedParameterPaths = preparedQuery.getIndexedParameterPaths();
                String propertyPath = indexedParameterPaths[i];
                if (propertyPath == null) throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                String string = preparedQuery.getLastUpdatedProperty();
                if (string != null && string.equals(propertyPath)) {
                    Class lastUpdatedType = preparedQuery.getLastUpdatedType();
                    if (lastUpdatedType == null) {
                        throw new IllegalStateException("Could not establish last updated time for entity: " + preparedQuery.getRootEntity());
                    }
                    Object timestamp = ConversionService.SHARED.convert(this.dateTimeProvider.getNow(), lastUpdatedType).orElse(null);
                    if (timestamp == null) {
                        throw new IllegalStateException("Unsupported date type: " + lastUpdatedType);
                    }
                    value = timestamp;
                } else {
                    int j = propertyPath.indexOf(46);
                    if (j <= -1) throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                    String subProp = propertyPath.substring(j + 1);
                    value = queryParameters[Integer.valueOf(propertyPath.substring(0, j))];
                    value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(subProp, Argument.OBJECT_ARGUMENT);
                }
            }
            if (QUERY_LOG.isTraceEnabled()) {
                QUERY_LOG.trace("Binding parameter at position {} to value {}", (Object)index, value);
            }
            if (value == null) {
                this.setStatementParameter(ps, index++, dataType, null, dialect);
                continue;
            }
            if (value == IGNORED_PARAMETER) continue;
            if (value instanceof Iterable) {
                Iterable iter = (Iterable)value;
                for (Object e : iter) {
                    this.setStatementParameter(ps, index++, dataType, e, dialect);
                }
                continue;
            }
            if (value.getClass().isArray()) {
                if (value instanceof byte[]) {
                    this.setStatementParameter(ps, index++, dataType, value, dialect);
                    continue;
                }
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object object = Array.get(value, j);
                    this.setStatementParameter(ps, index++, dataType, object, dialect);
                }
                continue;
            }
            this.setStatementParameter(ps, index++, dataType, value, dialect);
        }
        return ps;
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findStream method without an explicit query is not supported. Use findStream(PreparedQuery) instead");
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        throw new UnsupportedOperationException("The findPage method without an explicit query is not supported. Use findPage(PreparedQuery) instead");
    }

    @NonNull
    public <T> Iterable<T> persistAll(final @NonNull BatchOperation<T> operation) {
        AbstractSqlRepositoryOperations.StoredInsert insert = this.resolveInsert(operation);
        if (!insert.doesSupportBatch()) {
            ArrayList<T> results = new ArrayList<T>();
            for (final Object entity : operation) {
                results.add(this.persist(new InsertOperation<T>(){

                    @NonNull
                    public T getEntity() {
                        return entity;
                    }

                    @NonNull
                    public Class<T> getRootEntity() {
                        return operation.getRootEntity();
                    }

                    @NonNull
                    public Class<?> getRepositoryType() {
                        return operation.getRepositoryType();
                    }

                    public String getName() {
                        return operation.getName();
                    }

                    public AnnotationMetadata getAnnotationMetadata() {
                        return operation.getAnnotationMetadata();
                    }
                }));
            }
            return results;
        }
        return this.persistInBatch(operation.getAnnotationMetadata(), operation.getRepositoryType(), (Iterable<T>)operation, insert, new HashSet(10));
    }

    private <T> Iterable<T> persistInBatch(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Iterable<T> entities, AbstractSqlRepositoryOperations.StoredInsert<T> insert, Set persisted) {
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            Connection connection = (Connection)status.getConnection();
            ArrayList results = new ArrayList(10);
            boolean generateId = insert.isGenerateId();
            String insertSql = insert.getSql();
            BeanProperty identity = insert.getIdentityProperty();
            boolean hasGeneratedID = generateId && identity != null;
            try {
                PreparedStatement stmt = hasGeneratedID && insert.getDialect() == Dialect.ORACLE ? connection.prepareStatement(insertSql, new String[]{identity.getName()}) : connection.prepareStatement(insertSql, generateId ? 1 : 2);
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Batch SQL Insert: {}", (Object)insertSql);
                }
                for (Object entity : entities) {
                    if (persisted.contains(entity)) continue;
                    this.setInsertParameters(insert, entity, stmt);
                    stmt.addBatch();
                    results.add(entity);
                }
                stmt.executeBatch();
                if (hasGeneratedID) {
                    Iterator resultIterator = results.iterator();
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    while (resultIterator.hasNext()) {
                        Object entity = resultIterator.next();
                        if (!generatedKeys.next()) {
                            throw new DataAccessException("Failed to generate ID for entity: " + entity);
                        }
                        Object id = this.getEntityId(generatedKeys, insert.getIdentity().getDataType(), identity.getType());
                        if (identity.getType().isInstance(id)) {
                            identity.set(entity, id);
                            continue;
                        }
                        identity.convertAndSet(entity, id);
                    }
                }
                for (Object result : results) {
                    this.cascadeInserts(annotationMetadata, repositoryType, insert, result, persisted, connection, identity);
                }
                return results;
            }
            catch (SQLException e) {
                throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private Object getEntityId(ResultSet generatedKeys, DataType dataType, Class<Object> type) throws SQLException {
        Object id;
        switch (dataType) {
            case LONG: {
                id = generatedKeys.getLong(1);
                break;
            }
            case STRING: {
                id = generatedKeys.getString(1);
                break;
            }
            default: {
                id = generatedKeys.getObject(1, type);
            }
        }
        return id;
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NonNull
    public Connection getConnection() {
        return (Connection)this.transactionOperations.getConnection();
    }

    @Override
    @NonNull
    public <R> R execute(@NonNull ConnectionCallback<R> callback) {
        try {
            return callback.call((Connection)this.transactionOperations.getConnection());
        }
        catch (SQLException e) {
            throw new DataAccessException("Error executing SQL Callback: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public <R> R prepareStatement(@NonNull String sql, @NonNull PreparedStatementCallback<R> callback) {
        ArgumentUtils.requireNonNull((String)"sql", (Object)sql);
        ArgumentUtils.requireNonNull((String)"callback", callback);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)sql);
        }
        try {
            return callback.call(((Connection)this.transactionOperations.getConnection()).prepareStatement(sql));
        }
        catch (SQLException e) {
            throw new DataAccessException("Error preparing SQL statement: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @NonNull Class<T> rootEntity) {
        return this.entityStream(resultSet, null, rootEntity);
    }

    @Override
    @NonNull
    public <E> E readEntity(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> type) throws DataAccessException {
        return (E)new SqlResultEntityTypeMapper(prefix, this.getEntity(type), this.columnNameResultSetReader, this.jsonCodec).map((Object)resultSet, type);
    }

    @Override
    @NonNull
    public <E, D> D readDTO(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
        return (D)new DTOMapper(this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec).map((Object)resultSet, dtoType);
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @Nullable String prefix, @NonNull Class<T> rootEntity) {
        ArgumentUtils.requireNonNull((String)"resultSet", (Object)resultSet);
        ArgumentUtils.requireNonNull((String)"rootEntity", rootEntity);
        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec);
        Iterable iterable = () -> this.lambda$entityStream$12(resultSet, (TypeMapper)mapper, rootEntity);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private /* synthetic */ Iterator lambda$entityStream$12(final ResultSet resultSet, final TypeMapper mapper, final Class rootEntity) {
        return new Iterator<T>(){
            boolean nextCalled = false;

            @Override
            public boolean hasNext() {
                try {
                    if (!this.nextCalled) {
                        this.nextCalled = true;
                        return resultSet.next();
                    }
                    return this.nextCalled;
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public T next() {
                this.nextCalled = false;
                return mapper.map((Object)resultSet, rootEntity);
            }
        };
    }
}

