/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.chatbots.telegram.lambda;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import io.micronaut.chatbots.core.Dispatcher;
import io.micronaut.chatbots.lambda.AbstractHandler;
import io.micronaut.chatbots.telegram.api.Update;
import io.micronaut.chatbots.telegram.api.send.Send;
import io.micronaut.chatbots.telegram.core.TelegramBotConfiguration;
import io.micronaut.chatbots.telegram.core.TokenValidator;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.serde.ObjectMapper;
import jakarta.inject.Inject;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
extends AbstractHandler<TelegramBotConfiguration, Update, Send> {
    private static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    @Inject
    TokenValidator tokenValidator;
    @Inject
    ObjectMapper objectMapper;
    @Inject
    Dispatcher<TelegramBotConfiguration, Update, Send> dispatcher;

    public Handler() {
    }

    public Handler(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    public Handler(ApplicationContextBuilder applicationContextBuilder) {
        super(applicationContextBuilder);
    }

    @NonNull
    protected boolean validate(@NonNull APIGatewayProxyRequestEvent request) {
        return this.parseBot(request).isPresent();
    }

    @NonNull
    protected Optional<TelegramBotConfiguration> parseBot(@NonNull APIGatewayProxyRequestEvent request) {
        Optional<String> tokenOptional = this.parseToken(request);
        if (!tokenOptional.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("not token found");
            }
            return Optional.empty();
        }
        String token = tokenOptional.get();
        Optional botOptional = this.tokenValidator.validate(token);
        if (!botOptional.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("not bot with token that matches token {}", (Object)token);
            }
            return Optional.empty();
        }
        return botOptional;
    }

    @NonNull
    protected APIGatewayProxyResponseEvent okSerializer(@NonNull Object body) {
        return this.okJson(body);
    }

    @NonNull
    protected Optional<String> parseToken(@NonNull APIGatewayProxyRequestEvent request) {
        return this.parseHeader(request, "X-Telegram-Bot-Api-Secret-Token");
    }

    @NonNull
    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NonNull
    protected Dispatcher<TelegramBotConfiguration, Update, Send> getDispatcher() {
        return this.dispatcher;
    }
}

