/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.chatbots.basecamp.googlecloud;

import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import io.micronaut.chatbots.basecamp.api.Query;
import io.micronaut.chatbots.basecamp.core.BasecampBotConfiguration;
import io.micronaut.chatbots.core.Dispatcher;
import io.micronaut.function.executor.FunctionInitializer;
import io.micronaut.http.HttpStatus;
import io.micronaut.serde.ObjectMapper;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
extends FunctionInitializer
implements HttpFunction {
    private static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    @Inject
    Dispatcher<BasecampBotConfiguration, Query, String> dispatcher;
    @Inject
    ObjectMapper objectMapper;

    public void service(HttpRequest request, HttpResponse response) throws Exception {
        int statusCode;
        Query query = (Query)this.objectMapper.readValue(request.getInputStream(), Query.class);
        if (query == null) {
            LOG.warn("could not serialize request to Query");
            statusCode = HttpStatus.UNPROCESSABLE_ENTITY.getCode();
        } else {
            Optional htmlOptional = this.dispatcher.dispatch(null, (Object)query);
            if (htmlOptional.isPresent()) {
                String html = (String)htmlOptional.get();
                response.setContentType("text/html");
                response.getOutputStream().write(html.getBytes(StandardCharsets.UTF_8));
            }
            statusCode = HttpStatus.OK.getCode();
        }
        response.setStatusCode(statusCode);
    }
}

