/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.caffeine.graal;

import io.micronaut.core.annotation.Internal;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@Internal
public class CaffeineFeature
implements Feature {
    private static final CacheType[] COMMON_CACHE_TYPES = new CacheType[]{new CacheType("com.github.benmanes.caffeine.cache.PDMS", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.PSA", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.PSAW", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.PS", "key", "value"), new CacheType("com.github.benmanes.caffeine.cache.PSW", "writeTime"), new CacheType("com.github.benmanes.caffeine.cache.PSMS", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.PSWMS", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.PSWMW", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SILMS", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SSA", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SSAW", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SSLA", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SSLMS", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SSMS", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SSMSA", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SSMSW", new String[0]), new CacheType("com.github.benmanes.caffeine.cache.SSW", new String[0])};

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.registerFields(access, "com.github.benmanes.caffeine.cache.BLCHeader$DrainStatusRef", "drainStatus");
        this.registerFields(access, "com.github.benmanes.caffeine.cache.BBHeader$ReadCounterRef", "readCounter");
        this.registerFields(access, "com.github.benmanes.caffeine.cache.BBHeader$ReadAndWriteCounterRef", "writeCounter");
        this.registerFields(access, "com.github.benmanes.caffeine.cache.StripedBuffer", "tableBusy");
        this.registerFields(access, "java.lang.Thread", "threadLocalRandomProbe");
        for (CacheType commonCacheType : COMMON_CACHE_TYPES) {
            this.registerFieldsAndDeclaredConstructors(access, commonCacheType.className, commonCacheType.fields);
        }
    }

    private void registerFieldsAndDeclaredConstructors(Feature.BeforeAnalysisAccess access, String clz, String ... fields) {
        RuntimeReflection.register((Class[])new Class[]{access.findClassByName(clz)});
        RuntimeReflection.register((Executable[])access.findClassByName(clz).getDeclaredConstructors());
        this.registerFields(access, clz, fields);
    }

    private void registerFields(Feature.BeforeAnalysisAccess access, String clz, String ... fields) {
        for (Field field : access.findClassByName(clz).getDeclaredFields()) {
            if (!Arrays.asList(fields).contains(field.getName())) continue;
            RuntimeReflection.register((Field[])new Field[]{field});
        }
    }

    private record CacheType(String className, String[] fields) {
    }
}

