/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.handler;

import io.micrometer.common.KeyValue;
import io.micrometer.observation.Observation;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

class RevertingScope
implements CurrentTraceContext.Scope {
    private final TracingObservationHandler.TracingContext tracingContext;
    private final CurrentTraceContext.Scope currentScope;
    private final  @Nullable CurrentTraceContext.Scope previousScope;

    RevertingScope(TracingObservationHandler.TracingContext tracingContext, CurrentTraceContext.Scope currentScope,  @Nullable CurrentTraceContext.Scope previousScope) {
        this.tracingContext = tracingContext;
        this.currentScope = currentScope;
        this.previousScope = previousScope;
    }

    @Override
    public void close() {
        this.currentScope.close();
        this.tracingContext.setScope(this.previousScope);
    }

    public String toString() {
        return "RevertingScope{tracingContext=" + this.tracingContext + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevertingScope that = (RevertingScope)o;
        return Objects.equals(this.tracingContext, that.tracingContext) && Objects.equals(this.currentScope, that.currentScope) && Objects.equals(this.previousScope, that.previousScope);
    }

    public int hashCode() {
        return Objects.hash(this.tracingContext, this.currentScope, this.previousScope);
    }

    static RevertingScope maybeWithBaggage(Tracer tracer, TracingObservationHandler.TracingContext tracingContext, @Nullable TraceContext newContext, RevertingScope revertingScopeForSpan,  @Nullable CurrentTraceContext.Scope previousScopeOnThisObservation) {
        RevertingScope revertingScope = revertingScopeForSpan;
        Observation.ContextView context = tracingContext.getContext();
        if (context == null) {
            return revertingScope;
        }
        Collection<KeyValue> baggageKeyValues = RevertingScope.matchingBaggageKeyValues(tracer, context);
        if (baggageKeyValues.isEmpty()) {
            return revertingScope;
        }
        ArrayDeque<BaggageInScope> scopes = RevertingScope.startBaggageScopes(tracer, newContext, baggageKeyValues);
        return new RevertingScope(tracingContext, () -> {
            for (BaggageInScope scope : scopes) {
                scope.close();
            }
            revertingScope.close();
        }, previousScopeOnThisObservation);
    }

    private static ArrayDeque<BaggageInScope> startBaggageScopes(Tracer tracer, @Nullable TraceContext newContext, Collection<KeyValue> baggageKeyValues) {
        ArrayDeque<BaggageInScope> scopes = new ArrayDeque<BaggageInScope>();
        for (KeyValue keyValue : baggageKeyValues) {
            if (newContext != null) {
                scopes.addFirst(tracer.createBaggageInScope(newContext, keyValue.getKey(), keyValue.getValue()));
                continue;
            }
            scopes.addFirst(tracer.createBaggageInScope(keyValue.getKey(), keyValue.getValue()));
        }
        return scopes;
    }

    private static Collection<KeyValue> matchingBaggageKeyValues(Tracer tracer, Observation.ContextView context) {
        if (tracer.getBaggageFields().isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> lowerCaseRemoteFields = new HashSet<String>();
        for (String remoteField : tracer.getBaggageFields()) {
            lowerCaseRemoteFields.add(remoteField.toLowerCase());
        }
        ArrayList<KeyValue> baggageKeyValues = new ArrayList<KeyValue>();
        for (KeyValue keyValue : context.getAllKeyValues()) {
            if (!lowerCaseRemoteFields.contains(keyValue.getKey().toLowerCase())) continue;
            baggageKeyValues.add(keyValue);
        }
        return baggageKeyValues;
    }
}

