/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.exporter;

import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SpanIgnoringSpanExportingPredicate
implements SpanExportingPredicate {
    static final Map<String, Pattern> cache = new ConcurrentHashMap<String, Pattern>();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(SpanIgnoringSpanExportingPredicate.class);
    private final List<String> spanNamePatternsToSkip;
    private final List<String> additionalSpanNamePatternsToIgnore;

    public SpanIgnoringSpanExportingPredicate(List<String> spanNamePatternsToSkip, List<String> additionalSpanNamePatternsToIgnore) {
        this.spanNamePatternsToSkip = spanNamePatternsToSkip;
        this.additionalSpanNamePatternsToIgnore = additionalSpanNamePatternsToIgnore;
    }

    private List<Pattern> spanNamesToIgnore() {
        return this.spanNames().stream().map(regex -> cache.computeIfAbsent((String)regex, Pattern::compile)).collect(Collectors.toList());
    }

    private List<String> spanNames() {
        ArrayList<String> spanNamesToIgnore = new ArrayList<String>(this.spanNamePatternsToSkip);
        spanNamesToIgnore.addAll(this.additionalSpanNamePatternsToIgnore);
        return spanNamesToIgnore;
    }

    @Override
    public boolean isExportable(FinishedSpan span) {
        List<Pattern> spanNamesToIgnore = this.spanNamesToIgnore();
        String name = span.getName();
        if (StringUtils.isNotEmpty((String)name) && spanNamesToIgnore.stream().anyMatch(p -> p.matcher(name).matches())) {
            if (log.isDebugEnabled()) {
                log.debug("Will ignore a span with name [" + name + "]");
            }
            return false;
        }
        return true;
    }
}

