/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing;

import io.micrometer.common.lang.Nullable;

public interface SamplerFunction<T> {
    public static <T> SamplerFunction<T> deferDecision() {
        return Constants.DEFER_DECISION;
    }

    public static <T> SamplerFunction<T> neverSample() {
        return Constants.NEVER_SAMPLE;
    }

    public static <T> SamplerFunction<T> alwaysSample() {
        return Constants.ALWAYS_SAMPLE;
    }

    @Nullable
    public Boolean trySample(@Nullable T var1);

    public static enum Constants implements SamplerFunction<Object>
    {
        DEFER_DECISION{

            @Override
            public Boolean trySample(Object request) {
                return null;
            }

            public String toString() {
                return "DeferDecision";
            }
        }
        ,
        NEVER_SAMPLE{

            @Override
            public Boolean trySample(Object request) {
                return false;
            }

            public String toString() {
                return "NeverSample";
            }
        }
        ,
        ALWAYS_SAMPLE{

            @Override
            public Boolean trySample(Object request) {
                return true;
            }

            public String toString() {
                return "AlwaysSample";
            }
        };

    }
}

