/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.contextpropagation;

import io.micrometer.common.lang.NonNull;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ObservationAwareSpanThreadLocalAccessor
implements ThreadLocalAccessor<Span> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ObservationAwareSpanThreadLocalAccessor.class);
    final Map<Thread, SpanAction> spanActions = new ConcurrentHashMap<Thread, SpanAction>();
    public static final String KEY = "micrometer.tracing";
    private final ObservationRegistry registry;
    private final Tracer tracer;

    public ObservationAwareSpanThreadLocalAccessor(Tracer tracer) {
        this(ObservationRegistry.create(), tracer);
    }

    public ObservationAwareSpanThreadLocalAccessor(ObservationRegistry observationRegistry, Tracer tracer) {
        this.registry = Objects.requireNonNull(observationRegistry, "observationRegistry must not be null");
        this.tracer = Objects.requireNonNull(tracer, "tracer must not be null");
    }

    public Object key() {
        return KEY;
    }

    public Span getValue() {
        Observation currentObservation = this.registry.getCurrentObservation();
        if (currentObservation != null) {
            TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)currentObservation.getContext().getOrDefault(TracingObservationHandler.TracingContext.class, (Object)new TracingObservationHandler.TracingContext());
            Span currentSpan = this.tracer.currentSpan();
            if (currentSpan != null && !currentSpan.equals(tracingContext.getSpan())) {
                return new SpanWithBaggage(this.tracer, currentSpan);
            }
            return null;
        }
        Span span = this.tracer.currentSpan();
        if (span == null) {
            return span;
        }
        return new SpanWithBaggage(this.tracer, span);
    }

    public void setValue(Span value) {
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        Tracer.SpanInScope scope = value instanceof SpanWithBaggage ? this.tracer.withSpan(((SpanWithBaggage)value).delegate) : this.tracer.withSpan(value);
        SpanAction newSpanAction = new SpanAction(this.spanActions, spanAction);
        this.spanActions.put(Thread.currentThread(), newSpanAction);
        Consumer<Object> consumer = null;
        consumer = value instanceof SpanWithBaggage ? this.createNewScopesForAllPreviouslyStoredBaggage(value, consumer, scope) : o -> scope.close();
        newSpanAction.setScope(consumer);
    }

    private Consumer<?> createNewScopesForAllPreviouslyStoredBaggage(Span value, Consumer<?> consumer, Tracer.SpanInScope scope) {
        TraceContext context = value.context();
        SpanWithBaggage spanWithBaggage = (SpanWithBaggage)value;
        Map<String, String> storedBaggage = spanWithBaggage.baggage;
        for (Map.Entry<String, String> entry : storedBaggage.entrySet()) {
            consumer = this.appendBaggageScopeClosing(entry, context, consumer);
        }
        return ObservationAwareSpanThreadLocalAccessor.appendSpanScopeClosing(consumer, scope);
    }

    private Consumer<?> appendBaggageScopeClosing(Map.Entry<String, String> entry, TraceContext context, @Nullable Consumer<?> consumer) {
        String baggageKey = entry.getKey();
        String baggageValue = entry.getValue();
        BaggageInScope baggageInScope = this.tracer.createBaggageInScope(context, baggageKey, baggageValue);
        if (consumer == null) {
            return o -> baggageInScope.close();
        }
        return consumer.andThen(o -> baggageInScope.close());
    }

    private static Consumer<?> appendSpanScopeClosing(Consumer<?> consumer, Tracer.SpanInScope scope) {
        if (consumer != null) {
            return consumer.andThen(o -> scope.close());
        }
        return o -> scope.close();
    }

    public void setValue() {
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        if (spanAction == null) {
            return;
        }
        Tracer.SpanInScope scope = this.tracer.withSpan(null);
        Consumer<Object> consumer = o -> scope.close();
        spanAction.setScope(consumer);
    }

    public void restore(Span previousValue) {
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        if (spanAction == null) {
            return;
        }
        spanAction.close();
        Span currentSpan = this.tracer.currentSpan();
        if (previousValue instanceof SpanWithBaggage) {
            previousValue = ((SpanWithBaggage)previousValue).delegate;
        }
        if (!Objects.equals(previousValue, currentSpan)) {
            String msg = "After closing the scope, current span <" + currentSpan + "> is not the same as the one to which you want to revert <" + previousValue + ">. Most likely you've opened a scope and forgotten to close it";
            log.warn(msg);
            assert (false) : msg;
        }
    }

    public void restore() {
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        if (spanAction != null) {
            spanAction.close();
        }
    }

    static class SpanWithBaggage
    implements Span {
        private final Span delegate;
        final Map<String, String> baggage;

        SpanWithBaggage(Tracer tracer, @NonNull Span delegate) {
            this.delegate = delegate;
            this.baggage = tracer.getAllBaggage(delegate.context());
        }

        @Override
        public boolean isNoop() {
            return this.delegate.isNoop();
        }

        @Override
        public TraceContext context() {
            return this.delegate.context();
        }

        @Override
        public Span start() {
            return this.delegate.start();
        }

        @Override
        public Span name(String name) {
            return this.delegate.name(name);
        }

        @Override
        public Span event(String value) {
            return this.delegate.event(value);
        }

        @Override
        public Span event(String value, long time, TimeUnit timeUnit) {
            return this.delegate.event(value, time, timeUnit);
        }

        @Override
        public Span tag(String key, String value) {
            return this.delegate.tag(key, value);
        }

        @Override
        public Span tag(String key, long value) {
            return this.delegate.tag(key, value);
        }

        @Override
        public Span tag(String key, double value) {
            return this.delegate.tag(key, value);
        }

        @Override
        public Span tag(String key, boolean value) {
            return this.delegate.tag(key, value);
        }

        @Override
        public Span error(Throwable throwable) {
            return this.delegate.error(throwable);
        }

        @Override
        public void end() {
            this.delegate.end();
        }

        @Override
        public void end(long time, TimeUnit timeUnit) {
            this.delegate.end(time, timeUnit);
        }

        @Override
        public void abandon() {
            this.delegate.abandon();
        }

        @Override
        public Span remoteServiceName(String remoteServiceName) {
            return this.delegate.remoteServiceName(remoteServiceName);
        }

        @Override
        public Span remoteIpAndPort(String ip, int port) {
            return this.delegate.remoteIpAndPort(ip, port);
        }
    }

    static class SpanAction
    implements Closeable {
        final SpanAction previous;
        final Map<Thread, SpanAction> todo;
        Consumer<?> scope;

        SpanAction(Map<Thread, SpanAction> spanActions, SpanAction previous) {
            this.previous = previous;
            this.todo = spanActions;
        }

        void setScope(Consumer<?> scope) {
            this.scope = scope;
        }

        @Override
        public void close() {
            if (this.scope != null) {
                this.scope.accept(null);
            }
            if (this.previous != null) {
                this.todo.put(Thread.currentThread(), this.previous);
            } else {
                this.todo.remove(Thread.currentThread());
            }
        }
    }
}

