/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.common.docs.KeyName;
import io.micrometer.common.util.StringUtils;
import io.micrometer.tracing.Link;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.exporter.FinishedSpan;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractThrowableAssert;

public class SpanAssert<SELF extends SpanAssert<SELF>>
extends AbstractAssert<SELF, FinishedSpan> {
    protected SpanAssert(FinishedSpan actual) {
        super((Object)actual, SpanAssert.class);
    }

    public static SpanAssert assertThat(FinishedSpan actual) {
        return new SpanAssert(actual);
    }

    public static SpanAssert then(FinishedSpan actual) {
        return new SpanAssert(actual);
    }

    public SELF hasNoTags() {
        this.isNotNull();
        Map tags = ((FinishedSpan)this.actual).getTags();
        if (!tags.isEmpty()) {
            this.failWithMessage("Span should have no tags but has <%s>", new Object[]{tags});
        }
        return (SELF)((Object)this);
    }

    public SELF hasTagWithKey(String key) {
        this.isNotNull();
        if (!((FinishedSpan)this.actual).getTags().containsKey(key)) {
            this.failWithMessage("Span should have a tag with key <%s> but it's not there. List of all keys <%s>", new Object[]{key, ((FinishedSpan)this.actual).getTags().keySet()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasTagWithKey(KeyName key) {
        return this.hasTagWithKey(key.asString());
    }

    public SELF hasTag(String key, String value) {
        this.isNotNull();
        this.hasTagWithKey(key);
        Map tags = ((FinishedSpan)this.actual).getTags();
        String tagValue = (String)tags.get(key);
        if (!tagValue.equals(value)) {
            this.failWithMessage("Span should have a tag with key <%s> and value <%s>. The key is correct but the value is <%s>", new Object[]{key, value, tagValue});
        }
        return (SELF)((Object)this);
    }

    public SELF hasTag(KeyName key, String value) {
        return this.hasTag(key.asString(), value);
    }

    public SELF doesNotHaveTagWithKey(String key) {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getTags().containsKey(key)) {
            this.failWithMessage("Span should not have a tag with key <%s>", new Object[]{key, ((FinishedSpan)this.actual).getTags().keySet()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveTagWithKey(KeyName key) {
        return this.doesNotHaveTagWithKey(key.asString());
    }

    public SELF doesNotHaveTag(String key, String value) {
        this.isNotNull();
        this.doesNotHaveTagWithKey(key);
        Map tags = ((FinishedSpan)this.actual).getTags();
        String tagValue = (String)tags.get(key);
        if (value.equals(tagValue)) {
            this.failWithMessage("Span should not have a tag with key <%s> and value <%s>", new Object[]{key, value});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveTag(KeyName key, String value) {
        return this.doesNotHaveTag(key.asString(), value);
    }

    public SELF isStarted() {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getStartTimestamp().getEpochSecond() == 0L) {
            this.failWithMessage("Span should be started", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF isNotStarted() {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getStartTimestamp().getEpochSecond() != 0L) {
            this.failWithMessage("Span should not be started", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF isEnded() {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getEndTimestamp().toEpochMilli() == 0L) {
            this.failWithMessage("Span should be ended", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF isNotEnded() {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getEndTimestamp().toEpochMilli() != 0L) {
            this.failWithMessage("Span should not be ended", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SpanAssertReturningAssert assertThatThrowable() {
        return new SpanAssertReturningAssert(((FinishedSpan)this.actual).getError(), this);
    }

    public SpanAssertReturningAssert thenThrowable() {
        return this.assertThatThrowable();
    }

    public SELF hasRemoteServiceNameEqualTo(String remoteServiceName) {
        this.isNotNull();
        if (!remoteServiceName.equals(((FinishedSpan)this.actual).getRemoteServiceName())) {
            this.failWithMessage("Span should have remote service name equal to <%s> but has <%s>", new Object[]{remoteServiceName, ((FinishedSpan)this.actual).getRemoteServiceName()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveRemoteServiceNameEqualTo(String remoteServiceName) {
        this.isNotNull();
        if (remoteServiceName.equals(((FinishedSpan)this.actual).getRemoteServiceName())) {
            this.failWithMessage("Span should not have remote service name equal to <%s>", new Object[]{remoteServiceName});
        }
        return (SELF)((Object)this);
    }

    public SELF hasKindEqualTo(Span.Kind kind) {
        this.isNotNull();
        if (!kind.equals((Object)((FinishedSpan)this.actual).getKind())) {
            this.failWithMessage("Span should have span kind equal to <%s> but has <%s>", new Object[]{kind, ((FinishedSpan)this.actual).getKind()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveKindEqualTo(Span.Kind kind) {
        this.isNotNull();
        if (kind.equals((Object)((FinishedSpan)this.actual).getKind())) {
            this.failWithMessage("Span should not have span kind equal to <%s>", new Object[]{kind});
        }
        return (SELF)((Object)this);
    }

    public SELF hasEventWithNameEqualTo(String eventName) {
        this.isNotNull();
        List<String> eventNames = this.eventNames();
        if (!eventNames.contains(eventName)) {
            this.failWithMessage("Span should have an event with name <%s> but has <%s>", new Object[]{eventName, eventNames});
        }
        return (SELF)((Object)this);
    }

    private List<String> eventNames() {
        return ((FinishedSpan)this.actual).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public SELF doesNotHaveEventWithNameEqualTo(String eventName) {
        this.isNotNull();
        List<String> eventNames = this.eventNames();
        if (eventNames.contains(eventName)) {
            this.failWithMessage("Span should not have an event with name <%s>", new Object[]{eventName});
        }
        return (SELF)((Object)this);
    }

    public SELF hasNameEqualTo(String spanName) {
        this.isNotNull();
        if (!((FinishedSpan)this.actual).getName().equals(spanName)) {
            this.failWithMessage("Span should have a name <%s> but has <%s>", new Object[]{spanName, ((FinishedSpan)this.actual).getName()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveNameEqualTo(String spanName) {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getName().equals(spanName)) {
            this.failWithMessage("Span should not have a name <%s>", new Object[]{spanName, ((FinishedSpan)this.actual).getName()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasIpEqualTo(String ip) {
        this.isNotNull();
        if (!((FinishedSpan)this.actual).getRemoteIp().equals(ip)) {
            this.failWithMessage("Span should have ip equal to <%s> but has <%s>", new Object[]{ip, ((FinishedSpan)this.actual).getRemoteIp()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveIpEqualTo(String ip) {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getRemoteIp().equals(ip)) {
            this.failWithMessage("Span should not have ip equal to <%s>", new Object[]{ip, ((FinishedSpan)this.actual).getRemoteIp()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasIpThatIsNotBlank() {
        this.isNotNull();
        if (StringUtils.isBlank((String)((FinishedSpan)this.actual).getRemoteIp())) {
            this.failWithMessage("Span should have ip that is not blank", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF hasIpThatIsBlank() {
        this.isNotNull();
        if (StringUtils.isNotBlank((String)((FinishedSpan)this.actual).getRemoteIp())) {
            this.failWithMessage("Span should have ip that is blank", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF hasPortEqualTo(int port) {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getRemotePort() != port) {
            this.failWithMessage("Span should have port equal to <%s> but has <%s>", new Object[]{port, ((FinishedSpan)this.actual).getRemotePort()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHavePortEqualTo(int port) {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getRemotePort() == port) {
            this.failWithMessage("Span should not have port equal to <%s>", new Object[]{port, ((FinishedSpan)this.actual).getRemotePort()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasPortThatIsNotSet() {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getRemotePort() != 0) {
            this.failWithMessage("Span should have port that is not set but was set to <%s>", new Object[]{((FinishedSpan)this.actual).getRemotePort()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasPortThatIsSet() {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getRemotePort() == 0) {
            this.failWithMessage("Span should have port that is set but wasn't", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF hasLink(Link link) {
        this.isNotNull();
        if (!((FinishedSpan)this.actual).getLinks().contains(link)) {
            this.failWithMessage("Span should have a link <%s> but has <%s>", new Object[]{link, ((FinishedSpan)this.actual).getLinks()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveLink(Link link) {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getLinks().contains(link)) {
            this.failWithMessage("Span should not have a link but at least one was found <%s>", new Object[]{((FinishedSpan)this.actual).getLinks()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasLink(Consumer<Link> consumer) {
        this.isNotNull();
        boolean atLeastOnePassed = false;
        for (Link entry : ((FinishedSpan)this.actual).getLinks()) {
            try {
                consumer.accept(entry);
                atLeastOnePassed = true;
                break;
            }
            catch (AssertionError assertionError) {
            }
        }
        if (!atLeastOnePassed) {
            this.failWithMessage("Not a single link has passed the assertion", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveLink(Consumer<Link> consumer) {
        this.isNotNull();
        boolean allFailed = true;
        Link passingEntry = null;
        for (Link entry : ((FinishedSpan)this.actual).getLinks()) {
            try {
                consumer.accept(entry);
                allFailed = false;
                passingEntry = entry;
                break;
            }
            catch (AssertionError assertionError) {
            }
        }
        if (!allFailed) {
            this.failWithMessage("At least one a link has passed the assertion. First link passing assertion <%s>", new Object[]{passingEntry});
        }
        return (SELF)((Object)this);
    }

    public SELF hasSpanIdEqualTo(String spanId) {
        this.isNotNull();
        if (!((FinishedSpan)this.actual).getSpanId().equals(spanId)) {
            this.failWithMessage("Span should have span id equal to <%s> but has <%s>", new Object[]{spanId, ((FinishedSpan)this.actual).getSpanId()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveSpanIdEqualTo(String spanId) {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getSpanId().equals(spanId)) {
            this.failWithMessage("Span should not have span id equal to <%s>", new Object[]{spanId});
        }
        return (SELF)((Object)this);
    }

    public SELF hasTraceIdEqualTo(String spanId) {
        this.isNotNull();
        if (!((FinishedSpan)this.actual).getTraceId().equals(spanId)) {
            this.failWithMessage("Span should have trace id equal to <%s> but has <%s>", new Object[]{spanId, ((FinishedSpan)this.actual).getSpanId()});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveTraceIdEqualTo(String spanId) {
        this.isNotNull();
        if (((FinishedSpan)this.actual).getTraceId().equals(spanId)) {
            this.failWithMessage("Span should not have trace id equal to <%s>", new Object[]{spanId});
        }
        return (SELF)((Object)this);
    }

    public static class SpanAssertReturningAssert
    extends AbstractThrowableAssert<SpanAssertReturningAssert, Throwable> {
        private final SpanAssert spanAssert;

        public SpanAssertReturningAssert(Throwable throwable, SpanAssert spanAssert) {
            super(throwable, SpanAssertReturningAssert.class);
            this.spanAssert = spanAssert;
        }

        public SpanAssert backToSpan() {
            return this.spanAssert;
        }
    }
}

