/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.reporter.zipkin;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingReceiverTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.otel.bridge.OtelBaggageManager;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelFinishedSpan;
import io.micrometer.tracing.otel.bridge.OtelPropagator;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.micrometer.tracing.propagation.Propagator;
import io.micrometer.tracing.test.reporter.BuildingBlocks;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.ServiceAttributes;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public final class ZipkinOtelSetup
implements AutoCloseable {
    private final Consumer<Builder.OtelBuildingBlocks> closingFunction;
    private final Builder.OtelBuildingBlocks otelBuildingBlocks;

    ZipkinOtelSetup(Consumer<Builder.OtelBuildingBlocks> closingFunction, Builder.OtelBuildingBlocks otelBuildingBlocks) {
        this.closingFunction = closingFunction;
        this.otelBuildingBlocks = otelBuildingBlocks;
    }

    @Override
    public void close() {
        this.closingFunction.accept(this.otelBuildingBlocks);
    }

    public Builder.OtelBuildingBlocks getBuildingBlocks() {
        return this.otelBuildingBlocks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void run(ObservationRegistry registry, Consumer<Builder.OtelBuildingBlocks> consumer) {
        ZipkinOtelSetup.run(ZipkinOtelSetup.builder().register(registry), consumer);
    }

    public static void run(ZipkinOtelSetup localZipkinBrave, Consumer<Builder.OtelBuildingBlocks> consumer) {
        try {
            consumer.accept(localZipkinBrave.getBuildingBlocks());
        }
        finally {
            localZipkinBrave.close();
        }
    }

    public static class Builder {
        private String applicationName = "observability-test";
        private String zipkinUrl = "http://localhost:9411";
        private @Nullable Supplier<BytesMessageSender> sender;
        private @Nullable Function<BytesMessageSender, ZipkinSpanExporter> zipkinSpanExporter;
        private @Nullable Function<ZipkinSpanExporter, SdkTracerProvider> sdkTracerProvider;
        private @Nullable Function<SdkTracerProvider, OpenTelemetrySdk> openTelemetrySdk;
        private @Nullable Function<OpenTelemetrySdk, io.opentelemetry.api.trace.Tracer> tracer;
        private @Nullable Function<io.opentelemetry.api.trace.Tracer, OtelTracer> otelTracer;
        private @Nullable BiConsumer<BuildingBlocks, Deque<ObservationHandler<? extends // Could not load outer class - annotation placement on inner may be incorrect
        Observation.Context>>> customizers;
        private @Nullable Function<OtelBuildingBlocks, ObservationHandler<? extends // Could not load outer class - annotation placement on inner may be incorrect
        Observation.Context>> handlers;
        private @Nullable Consumer<OtelBuildingBlocks> closingFunction;

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder zipkinUrl(String zipkinUrl) {
            this.zipkinUrl = zipkinUrl;
            return this;
        }

        public Builder sender(Supplier<BytesMessageSender> sender) {
            this.sender = sender;
            return this;
        }

        public Builder zipkinSpanExporter(Function<BytesMessageSender, ZipkinSpanExporter> zipkinSpanExporter) {
            this.zipkinSpanExporter = zipkinSpanExporter;
            return this;
        }

        public Builder sdkTracerProvider(Function<ZipkinSpanExporter, SdkTracerProvider> sdkTracerProvider) {
            this.sdkTracerProvider = sdkTracerProvider;
            return this;
        }

        public Builder openTelemetrySdk(Function<SdkTracerProvider, OpenTelemetrySdk> openTelemetrySdk) {
            this.openTelemetrySdk = openTelemetrySdk;
            return this;
        }

        public Builder tracer(Function<OpenTelemetrySdk, io.opentelemetry.api.trace.Tracer> tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder otelTracer(Function<io.opentelemetry.api.trace.Tracer, OtelTracer> otelTracer) {
            this.otelTracer = otelTracer;
            return this;
        }

        public Builder observationHandlerCustomizer(BiConsumer<BuildingBlocks, Deque<ObservationHandler<? extends Observation.Context>>> customizers) {
            this.customizers = customizers;
            return this;
        }

        public Builder handlers(Function<OtelBuildingBlocks, ObservationHandler<? extends Observation.Context>> handlers) {
            this.handlers = handlers;
            return this;
        }

        public Builder closingFunction(Consumer<OtelBuildingBlocks> closingFunction) {
            this.closingFunction = closingFunction;
            return this;
        }

        public ZipkinOtelSetup register(ObservationRegistry registry) {
            BytesMessageSender sender = this.sender != null ? this.sender.get() : Builder.sender(this.zipkinUrl);
            ZipkinSpanExporter zipkinSpanExporter = this.zipkinSpanExporter != null ? this.zipkinSpanExporter.apply(sender) : Builder.zipkinSpanExporter(sender);
            InMemorySpanExporter arrayListSpanProcessor = InMemorySpanExporter.create();
            SdkTracerProvider sdkTracerProvider = this.sdkTracerProvider != null ? this.sdkTracerProvider.apply(zipkinSpanExporter) : Builder.sdkTracerProvider(zipkinSpanExporter, arrayListSpanProcessor, this.applicationName);
            OpenTelemetrySdk openTelemetrySdk = this.openTelemetrySdk != null ? this.openTelemetrySdk.apply(sdkTracerProvider) : Builder.openTelemetrySdk(sdkTracerProvider);
            io.opentelemetry.api.trace.Tracer tracer = this.tracer != null ? this.tracer.apply(openTelemetrySdk) : Builder.tracer(openTelemetrySdk);
            OtelTracer otelTracer = this.otelTracer != null ? this.otelTracer.apply(tracer) : Builder.otelTracer(tracer);
            BiConsumer<BuildingBlocks, Deque<ObservationHandler<? extends Observation.Context>>> customizers = this.customizers != null ? this.customizers : (t, h) -> {};
            OtelBuildingBlocks otelBuildingBlocks = new OtelBuildingBlocks(sender, zipkinSpanExporter, sdkTracerProvider, openTelemetrySdk, tracer, otelTracer, new OtelPropagator(Builder.propagators(Collections.singletonList(B3Propagator.injectingMultiHeaders())), tracer), customizers, arrayListSpanProcessor);
            ObservationHandler<Observation.Context> tracingHandlers = this.handlers != null ? this.handlers.apply(otelBuildingBlocks) : Builder.tracingHandlers(otelBuildingBlocks);
            registry.observationConfig().observationHandler(tracingHandlers);
            Consumer<OtelBuildingBlocks> closingFunction = this.closingFunction != null ? this.closingFunction : Builder.closingFunction();
            return new ZipkinOtelSetup(closingFunction, otelBuildingBlocks);
        }

        private static BytesMessageSender sender(String zipkinUrl) {
            return URLConnectionSender.newBuilder().connectTimeout(1000).readTimeout(1000).endpoint((zipkinUrl.endsWith("/") ? zipkinUrl.substring(0, zipkinUrl.length() - 1) : zipkinUrl) + "/api/v2/spans").build();
        }

        private static ZipkinSpanExporter zipkinSpanExporter(BytesMessageSender sender) {
            return ZipkinSpanExporter.builder().setSender(sender).build();
        }

        private static SdkTracerProvider sdkTracerProvider(ZipkinSpanExporter zipkinSpanExporter, InMemorySpanExporter arrayListSpanProcessor, String applicationName) {
            return SdkTracerProvider.builder().setSampler(Sampler.alwaysOn()).addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)arrayListSpanProcessor)).addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)zipkinSpanExporter).setScheduleDelay(100L, TimeUnit.MILLISECONDS).setExporterTimeout(300L, TimeUnit.MILLISECONDS).build()).setResource(Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ServiceAttributes.SERVICE_NAME, (Object)applicationName)))).build();
        }

        private static OpenTelemetrySdk openTelemetrySdk(SdkTracerProvider sdkTracerProvider) {
            return OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)B3Propagator.injectingSingleHeader())).build();
        }

        private static io.opentelemetry.api.trace.Tracer tracer(OpenTelemetrySdk openTelemetrySdk) {
            return openTelemetrySdk.getTracerProvider().get("io.micrometer.micrometer-tracing");
        }

        private static OtelTracer otelTracer(io.opentelemetry.api.trace.Tracer tracer) {
            OtelCurrentTraceContext otelCurrentTraceContext = new OtelCurrentTraceContext();
            return new OtelTracer(tracer, otelCurrentTraceContext, event -> {}, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)otelCurrentTraceContext, Collections.emptyList(), Collections.emptyList()));
        }

        private static ContextPropagators propagators(List<TextMapPropagator> propagators) {
            if (propagators.isEmpty()) {
                return ContextPropagators.noop();
            }
            return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite(propagators));
        }

        private static Consumer<OtelBuildingBlocks> closingFunction() {
            return deps -> ((OtelBuildingBlocks)deps).sdkTracerProvider.close();
        }

        private static ObservationHandler<Observation.Context> tracingHandlers(OtelBuildingBlocks otelBuildingBlocks) {
            OtelTracer tracer = otelBuildingBlocks.otelTracer;
            LinkedList<Object> handlers = new LinkedList<Object>();
            handlers.add(new PropagatingSenderTracingObservationHandler((Tracer)tracer, (Propagator)otelBuildingBlocks.propagator));
            handlers.add(new PropagatingReceiverTracingObservationHandler((Tracer)tracer, (Propagator)otelBuildingBlocks.propagator));
            handlers.add(new DefaultTracingObservationHandler((Tracer)tracer));
            otelBuildingBlocks.customizers.accept(otelBuildingBlocks, handlers);
            return new ObservationHandler.FirstMatchingCompositeObservationHandler(handlers);
        }

        public static class OtelBuildingBlocks
        implements BuildingBlocks {
            private final BytesMessageSender sender;
            private final ZipkinSpanExporter zipkinSpanExporter;
            private final SdkTracerProvider sdkTracerProvider;
            private final OpenTelemetrySdk openTelemetrySdk;
            private final io.opentelemetry.api.trace.Tracer tracer;
            private final OtelTracer otelTracer;
            private final OtelPropagator propagator;
            private final BiConsumer<BuildingBlocks, Deque<ObservationHandler<? extends Observation.Context>>> customizers;
            private final InMemorySpanExporter arrayListSpanProcessor;

            public OtelBuildingBlocks(BytesMessageSender sender, ZipkinSpanExporter zipkinSpanExporter, SdkTracerProvider sdkTracerProvider, OpenTelemetrySdk openTelemetrySdk, io.opentelemetry.api.trace.Tracer tracer, OtelTracer otelTracer, OtelPropagator propagator, BiConsumer<BuildingBlocks, Deque<ObservationHandler<? extends Observation.Context>>> customizers, InMemorySpanExporter arrayListSpanProcessor) {
                this.sender = sender;
                this.zipkinSpanExporter = zipkinSpanExporter;
                this.sdkTracerProvider = sdkTracerProvider;
                this.openTelemetrySdk = openTelemetrySdk;
                this.tracer = tracer;
                this.otelTracer = otelTracer;
                this.propagator = propagator;
                this.customizers = customizers;
                this.arrayListSpanProcessor = arrayListSpanProcessor;
            }

            public BytesMessageSender getSender() {
                return this.sender;
            }

            @Override
            public Tracer getTracer() {
                return this.otelTracer;
            }

            @Override
            public BiConsumer<BuildingBlocks, Deque<ObservationHandler<? extends Observation.Context>>> getCustomizers() {
                return this.customizers;
            }

            @Override
            public List<FinishedSpan> getFinishedSpans() {
                return this.arrayListSpanProcessor.getFinishedSpanItems().stream().map(OtelFinishedSpan::fromOtel).collect(Collectors.toList());
            }

            public OtelPropagator getPropagator() {
                return this.propagator;
            }
        }
    }
}

