/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.lang.Nullable;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import java.util.function.Function;

public final class EventPublishingContextWrapper
implements Function<ContextStorage, ContextStorage> {
    private final OtelTracer.EventPublisher publisher;

    public EventPublishingContextWrapper(OtelTracer.EventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public ContextStorage apply(final ContextStorage contextStorage) {
        return new ContextStorage(){

            public Scope attach(Context context) {
                Context currentContext = Context.current();
                Scope scope = contextStorage.attach(context);
                if (scope == Scope.noop()) {
                    return scope;
                }
                EventPublishingContextWrapper.this.publisher.publishEvent(new ScopeAttachedEvent(context));
                return () -> {
                    scope.close();
                    EventPublishingContextWrapper.this.publisher.publishEvent(new ScopeClosedEvent());
                    EventPublishingContextWrapper.this.publisher.publishEvent(new ScopeRestoredEvent(currentContext));
                };
            }

            public Context current() {
                return contextStorage.current();
            }
        };
    }

    public static class ScopeRestoredEvent {
        final Context context;

        public ScopeRestoredEvent(@Nullable Context context) {
            this.context = context;
        }

        public Span getSpan() {
            return Span.fromContextOrNull((Context)this.context);
        }

        public Baggage getBaggage() {
            return Baggage.fromContextOrNull((Context)this.context);
        }

        public String toString() {
            return "ScopeRestored{context: [span: " + this.getSpan() + "] [baggage: " + this.getBaggage() + "]}";
        }
    }

    public static class ScopeClosedEvent {
    }

    public static class ScopeAttachedEvent {
        final Context context;

        public ScopeAttachedEvent(@Nullable Context context) {
            this.context = context;
        }

        public Span getSpan() {
            return Span.fromContextOrNull((Context)this.context);
        }

        public Baggage getBaggage() {
            return Baggage.fromContextOrNull((Context)this.context);
        }

        public String toString() {
            return "ScopeAttached{context: [span: " + this.getSpan() + "] [baggage: " + this.getBaggage() + "]}";
        }
    }
}

