/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.SpanCustomizer;
import io.micrometer.tracing.http.HttpRequest;
import io.micrometer.tracing.http.HttpRequestParser;
import io.micrometer.tracing.http.HttpResponse;
import io.micrometer.tracing.http.HttpResponseParser;
import io.micrometer.tracing.http.HttpServerHandler;
import io.micrometer.tracing.http.HttpServerRequest;
import io.micrometer.tracing.http.HttpServerResponse;
import io.micrometer.tracing.otel.bridge.HttpRequestNetServerAttributesExtractor;
import io.micrometer.tracing.otel.bridge.OtelHttpClientHandler;
import io.micrometer.tracing.otel.bridge.OtelSpan;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.PathAttributeExtractor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import java.util.regex.Pattern;

@Deprecated
public class OtelHttpServerHandler
implements HttpServerHandler {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(OtelHttpClientHandler.class);
    private static final ContextKey<HttpServerRequest> REQUEST_CONTEXT_KEY = ContextKey.named((String)(OtelHttpServerHandler.class.getName() + ".request"));
    private final HttpRequestParser httpServerRequestParser;
    private final HttpResponseParser httpServerResponseParser;
    private final Pattern pattern;
    private final Instrumenter<HttpServerRequest, HttpServerResponse> instrumenter;

    public OtelHttpServerHandler(OpenTelemetry openTelemetry, @Nullable HttpRequestParser httpServerRequestParser, @Nullable HttpResponseParser httpServerResponseParser, Pattern skipPattern, HttpServerAttributesGetter<HttpServerRequest, HttpServerResponse> httpAttributesExtractor) {
        this.httpServerRequestParser = httpServerRequestParser;
        this.httpServerResponseParser = httpServerResponseParser;
        this.pattern = skipPattern;
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.micrometer.tracing", (SpanNameExtractor)HttpSpanNameExtractor.create(httpAttributesExtractor)).setSpanStatusExtractor(HttpSpanStatusExtractor.create(httpAttributesExtractor)).addAttributesExtractor(HttpServerAttributesExtractor.create(httpAttributesExtractor, (NetServerAttributesGetter)new HttpRequestNetServerAttributesExtractor())).addAttributesExtractor((AttributesExtractor)new PathAttributeExtractor()).buildServerInstrumenter(this.getGetter());
    }

    public Span handleReceive(HttpServerRequest request) {
        boolean shouldSkip;
        String url = request.path();
        boolean bl = shouldSkip = !StringUtils.isEmpty((String)url) && this.pattern.matcher(url).matches();
        if (shouldSkip) {
            return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
        }
        Context parentContext = Context.current();
        if (this.instrumenter.shouldStart(parentContext, (Object)request)) {
            Context context = this.instrumenter.start(parentContext, (Object)request);
            return this.span(context, request);
        }
        return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
    }

    private Span span(Context context, HttpServerRequest request) {
        io.opentelemetry.api.trace.Span span = io.opentelemetry.api.trace.Span.fromContext((Context)context);
        Span result = OtelSpan.fromOtel(span, context.with(REQUEST_CONTEXT_KEY, (Object)request));
        if (this.httpServerRequestParser != null) {
            this.httpServerRequestParser.parse((HttpRequest)request, result.context(), (SpanCustomizer)result);
        }
        return result;
    }

    public void handleSend(HttpServerResponse response, Span span) {
        OtelSpan otelSpanWrapper = (OtelSpan)span;
        if (!otelSpanWrapper.delegate.getSpanContext().isValid()) {
            if (log.isDebugEnabled()) {
                log.debug("Not doing anything because the span is invalid");
            }
            return;
        }
        if (this.httpServerResponseParser != null) {
            this.httpServerResponseParser.parse((HttpResponse)response, span.context(), (SpanCustomizer)span);
        }
        OtelTraceContext traceContext = otelSpanWrapper.context();
        Context otelContext = traceContext.context();
        this.instrumenter.end(otelContext, (Object)((HttpServerRequest)otelContext.get(REQUEST_CONTEXT_KEY)), (Object)response, response.error());
    }

    private TextMapGetter<HttpServerRequest> getGetter() {
        return new TextMapGetter<HttpServerRequest>(){

            public Iterable<String> keys(HttpServerRequest carrier) {
                return carrier.headerNames();
            }

            public String get(HttpServerRequest carrier, String key) {
                return carrier.header(key);
            }
        };
    }
}

