/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.ScopedSpan;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.SpanCustomizer;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.otel.bridge.EventPublishingContextWrapper;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelScopedSpan;
import io.micrometer.tracing.otel.bridge.OtelSpan;
import io.micrometer.tracing.otel.bridge.OtelSpanBuilder;
import io.micrometer.tracing.otel.bridge.OtelSpanCustomizer;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.OtelTraceContextBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class OtelTracer
implements Tracer {
    private final io.opentelemetry.api.trace.Tracer tracer;
    private final BaggageManager otelBaggageManager;
    private final OtelCurrentTraceContext otelCurrentTraceContext;
    private final EventPublisher publisher;

    public OtelTracer(io.opentelemetry.api.trace.Tracer tracer, OtelCurrentTraceContext otelCurrentTraceContext, EventPublisher publisher, BaggageManager otelBaggageManager) {
        this.tracer = tracer;
        this.publisher = publisher;
        this.otelBaggageManager = otelBaggageManager;
        this.otelCurrentTraceContext = otelCurrentTraceContext;
    }

    public OtelTracer(io.opentelemetry.api.trace.Tracer tracer, OtelCurrentTraceContext otelCurrentTraceContext, EventPublisher publisher) {
        this(tracer, otelCurrentTraceContext, publisher, (BaggageManager)NOOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span nextSpan(Span parent) {
        if (parent == null) {
            return this.nextSpan();
        }
        OtelSpan otelSpan = (OtelSpan)parent;
        AtomicReference<Context> context = otelSpan.context().context;
        Context otelContext = context.get();
        Scope scope = null;
        if (otelContext != null && Context.current() != otelContext) {
            scope = otelContext.makeCurrent();
        }
        try {
            Span span = OtelSpan.fromOtel(this.tracer.spanBuilder("").setParent(OtelTraceContext.toOtelContext(parent.context())).startSpan());
            return span;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    public Tracer.SpanInScope withSpan(Span span) {
        io.opentelemetry.api.trace.Span delegate = this.delegate(span);
        CurrentTraceContext.Scope scope = this.otelCurrentTraceContext.maybeScope(OtelSpan.fromOtel(delegate).context());
        return new WrappedSpanInScope(scope);
    }

    private io.opentelemetry.api.trace.Span delegate(Span span) {
        if (span == null) {
            this.publisher.publishEvent(new EventPublishingContextWrapper.ScopeClosedEvent());
            return io.opentelemetry.api.trace.Span.getInvalid();
        }
        return ((OtelSpan)span).delegate;
    }

    public SpanCustomizer currentSpanCustomizer() {
        return new OtelSpanCustomizer();
    }

    public Span currentSpan() {
        io.opentelemetry.api.trace.Span currentSpan = io.opentelemetry.api.trace.Span.current();
        if (currentSpan == null || currentSpan.equals((Object)io.opentelemetry.api.trace.Span.getInvalid())) {
            return null;
        }
        return new OtelSpan(currentSpan);
    }

    public Span nextSpan() {
        return new OtelSpan(this.tracer.spanBuilder("").startSpan());
    }

    public ScopedSpan startScopedSpan(String name) {
        io.opentelemetry.api.trace.Span span = this.tracer.spanBuilder(name).startSpan();
        return new OtelScopedSpan(span, span.makeCurrent());
    }

    public Span.Builder spanBuilder() {
        return new OtelSpanBuilder(this.tracer.spanBuilder(""));
    }

    public TraceContext.Builder traceContextBuilder() {
        return new OtelTraceContextBuilder();
    }

    public CurrentTraceContext currentTraceContext() {
        return this.otelCurrentTraceContext;
    }

    public Map<String, String> getAllBaggage() {
        return this.otelBaggageManager.getAllBaggage();
    }

    public Baggage getBaggage(String name) {
        return this.otelBaggageManager.getBaggage(name);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        return this.otelBaggageManager.getBaggage(traceContext, name);
    }

    public Baggage createBaggage(String name) {
        return this.otelBaggageManager.createBaggage(name);
    }

    public Baggage createBaggage(String name, String value) {
        return this.otelBaggageManager.createBaggage(name, value);
    }

    public static interface EventPublisher {
        public void publishEvent(Object var1);
    }

    static class WrappedSpanInScope
    implements Tracer.SpanInScope {
        final CurrentTraceContext.Scope scope;

        WrappedSpanInScope(CurrentTraceContext.Scope scope) {
            this.scope = scope;
        }

        public void close() {
            this.scope.close();
        }
    }
}

