/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.lang.Nullable;
import io.micrometer.tracing.http.HttpServerRequest;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import java.net.URI;

class HttpRequestNetServerAttributesExtractor
implements NetServerAttributesGetter<HttpServerRequest> {
    HttpRequestNetServerAttributesExtractor() {
    }

    @Nullable
    public String transport(HttpServerRequest httpRequest) {
        String url = httpRequest.url();
        if (url == null) {
            return null;
        }
        URI uri = URI.create(url);
        return uri.getScheme();
    }

    @Nullable
    public String hostName(HttpServerRequest httpRequest) {
        String url = httpRequest.url();
        if (url == null) {
            return null;
        }
        URI uri = URI.create(url);
        return uri.getHost();
    }

    public Integer hostPort(HttpServerRequest httpRequest) {
        return httpRequest.remotePort();
    }

    @Nullable
    public String sockPeerAddr(HttpServerRequest httpRequest) {
        return httpRequest.remoteIp();
    }

    @Nullable
    public Integer sockPeerPort(HttpServerRequest httpRequest) {
        return httpRequest.remotePort();
    }
}

