/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

interface LongTaskTimerTest {
    @Test
    @DisplayName(value="total time is preserved for a single timing")
    default public void record(MeterRegistry registry) {
        LongTaskTimer t = registry.more().longTaskTimer("my.timer", new String[0]);
        LongTaskTimer.Sample sample = t.start();
        MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.duration(TimeUnit.NANOSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.01, (double)t.duration(TimeUnit.MICROSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)sample.duration(TimeUnit.NANOSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.01, (double)sample.duration(TimeUnit.MICROSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)t.activeTasks())});
        MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
        sample.stop();
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)t.duration(TimeUnit.NANOSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((double)-1.0, (double)sample.duration(TimeUnit.NANOSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)t.activeTasks())});
    }

    @Test
    @DisplayName(value="supports sending the Nth percentile active task duration")
    default public void percentiles(MeterRegistry registry) {
        LongTaskTimer t = LongTaskTimer.builder((String)"my.timer").publishPercentiles(new double[]{0.5, 0.7, 0.91, 0.999, 1.0}).register(registry);
        List<Integer> samples = Arrays.asList(48, 42, 40, 35, 22, 16, 13, 8, 6, 4, 2);
        int prior = samples.get(0);
        for (Integer value : samples) {
            MockClock.clock((MeterRegistry)registry).add((long)(prior - value), TimeUnit.SECONDS);
            t.start();
            prior = value;
        }
        MockClock.clock((MeterRegistry)registry).add((long)samples.get(samples.size() - 1).intValue(), TimeUnit.SECONDS);
        Assertions.assertThat((int)t.activeTasks()).isEqualTo(11);
        ValueAtPercentile[] percentiles = t.takeSnapshot().percentileValues();
        Assertions.assertThat((double)percentiles[0].percentile()).isEqualTo(0.5);
        Assertions.assertThat((double)percentiles[0].value(TimeUnit.SECONDS)).isEqualTo(16.0);
        Assertions.assertThat((double)percentiles[1].percentile()).isEqualTo(0.7);
        Assertions.assertThat((double)percentiles[1].value(TimeUnit.SECONDS)).isEqualTo(37.0, Assertions.within((Double)0.001));
        Assertions.assertThat((double)percentiles[2].percentile()).isEqualTo(0.91);
        Assertions.assertThat((double)percentiles[2].value(TimeUnit.SECONDS)).isEqualTo(47.5, Assertions.within((Double)0.1));
        Assertions.assertThat((double)percentiles[3].percentile()).isEqualTo(0.999);
        Assertions.assertThat((double)percentiles[3].value(TimeUnit.SECONDS)).isEqualTo(48.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)percentiles[4].percentile()).isEqualTo(1.0);
        Assertions.assertThat((double)percentiles[4].value(TimeUnit.SECONDS)).isEqualTo(48.0);
    }

    @Test
    @DisplayName(value="supports sending histograms of active task duration")
    default public void histogram(MeterRegistry registry) {
        LongTaskTimer t = LongTaskTimer.builder((String)"my.timer").serviceLevelObjectives(new Duration[]{Duration.ofSeconds(10L), Duration.ofSeconds(40L), Duration.ofMinutes(1L)}).register(registry);
        List<Integer> samples = Arrays.asList(48, 42, 40, 35, 22, 16, 13, 8, 6, 4, 2);
        int prior = samples.get(0);
        for (Integer value : samples) {
            MockClock.clock((MeterRegistry)registry).add((long)(prior - value), TimeUnit.SECONDS);
            t.start();
            prior = value;
        }
        MockClock.clock((MeterRegistry)registry).add((long)samples.get(samples.size() - 1).intValue(), TimeUnit.SECONDS);
        CountAtBucket[] countAtBuckets = t.takeSnapshot().histogramCounts();
        Assertions.assertThat((double)countAtBuckets[0].bucket(TimeUnit.SECONDS)).isEqualTo(10.0);
        Assertions.assertThat((double)countAtBuckets[0].count()).isEqualTo(4.0);
        Assertions.assertThat((double)countAtBuckets[1].bucket(TimeUnit.SECONDS)).isEqualTo(40.0);
        Assertions.assertThat((double)countAtBuckets[1].count()).isEqualTo(9.0);
        Assertions.assertThat((double)countAtBuckets[2].bucket(TimeUnit.MINUTES)).isEqualTo(1.0);
        Assertions.assertThat((double)countAtBuckets[2].count()).isEqualTo(11.0);
    }
}

