/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.observation.DefaultMeterObservationHandler;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.tck.TestObservationRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.util.AnnotationUtils;

abstract class InstrumentationVerificationTests {
    private final MeterRegistry registry = new SimpleMeterRegistry();
    private final TestObservationRegistry testObservationRegistry = this.createObservationRegistryWithMetrics();

    InstrumentationVerificationTests() {
    }

    protected MeterRegistry getRegistry() {
        return this.registry;
    }

    protected TestObservationRegistry createObservationRegistryWithMetrics() {
        TestObservationRegistry observationRegistry = TestObservationRegistry.create();
        observationRegistry.observationConfig().observationHandler((ObservationHandler)new DefaultMeterObservationHandler(this.getRegistry()));
        return observationRegistry;
    }

    protected TestObservationRegistry getObservationRegistry() {
        return this.testObservationRegistry;
    }

    static class MappedParameterContext
    implements ParameterContext {
        private final int index;
        private final Parameter parameter;
        private final Optional<Object> target;

        MappedParameterContext(int index, Parameter parameter, Optional<Object> target) {
            this.index = index;
            this.parameter = parameter;
            this.target = target;
        }

        public boolean isAnnotated(Class<? extends Annotation> annotationType) {
            return AnnotationUtils.isAnnotated((AnnotatedElement)this.parameter, annotationType);
        }

        public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
            return AnnotationUtils.findAnnotation((AnnotatedElement)this.parameter, annotationType);
        }

        public <A extends Annotation> List<A> findRepeatableAnnotations(Class<A> annotationType) {
            return AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)this.parameter, annotationType);
        }

        public int getIndex() {
            return this.index;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        public Optional<Object> getTarget() {
            return this.target;
        }
    }

    static class AfterBeforeParameterResolver
    implements BeforeEachMethodAdapter,
    ParameterResolver {
        private static final Set<String> PARAMETER_RESOLVERS = new HashSet<String>(Arrays.asList("org.junit.jupiter.params.ParameterizedTestMethodParameterResolver", "org.junit.jupiter.params.ParameterizedTestParameterResolver"));
        private ParameterResolver parameterizedTestParameterResolver;

        AfterBeforeParameterResolver() {
        }

        public void invokeBeforeEachMethod(ExtensionContext context, ExtensionRegistry registry) {
            this.parameterizedTestParameterResolver = registry.getExtensions(ParameterResolver.class).stream().filter(this::isParameterizedTestMethodParameterResolver).findFirst().orElseThrow(() -> new IllegalStateException("Parameterized test resolver was not found in JUnit's ExtensionRegistry. Probably it's not a Parameterized Test."));
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            if (this.isExecutedOnAfterOrBeforeMethod(parameterContext)) {
                MappedParameterContext pContext = this.getMappedContext(parameterContext, extensionContext);
                return this.parameterizedTestParameterResolver.supportsParameter((ParameterContext)pContext, extensionContext);
            }
            return false;
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.parameterizedTestParameterResolver.resolveParameter((ParameterContext)this.getMappedContext(parameterContext, extensionContext), extensionContext);
        }

        private boolean isParameterizedTestMethodParameterResolver(ParameterResolver parameterResolver) {
            return PARAMETER_RESOLVERS.contains(parameterResolver.getClass().getName());
        }

        private MappedParameterContext getMappedContext(ParameterContext parameterContext, ExtensionContext extensionContext) {
            return new MappedParameterContext(parameterContext.getIndex(), extensionContext.getRequiredTestMethod().getParameters()[parameterContext.getIndex()], Optional.of(parameterContext.getTarget()));
        }

        private boolean isExecutedOnAfterOrBeforeMethod(ParameterContext parameterContext) {
            return Arrays.stream(parameterContext.getDeclaringExecutable().getDeclaredAnnotations()).anyMatch(this::isAfterEachOrBeforeEachAnnotation);
        }

        private boolean isAfterEachOrBeforeEachAnnotation(Annotation annotation) {
            return annotation.annotationType() == BeforeEach.class || annotation.annotationType() == AfterEach.class;
        }
    }

    static enum TestType {
        METRICS_VIA_METER_REGISTRY,
        METRICS_VIA_OBSERVATIONS_WITH_METRICS_HANDLER;

    }
}

