/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.util.retry;

import io.micrometer.shaded.reactor.util.retry.Retry;

final class ImmutableRetrySignal
implements Retry.RetrySignal {
    final long failureTotalIndex;
    final long failureSubsequentIndex;
    final Throwable failure;

    ImmutableRetrySignal(long failureTotalIndex, long failureSubsequentIndex, Throwable failure) {
        this.failureTotalIndex = failureTotalIndex;
        this.failureSubsequentIndex = failureSubsequentIndex;
        this.failure = failure;
    }

    @Override
    public long totalRetries() {
        return this.failureTotalIndex;
    }

    @Override
    public long totalRetriesInARow() {
        return this.failureSubsequentIndex;
    }

    @Override
    public Throwable failure() {
        return this.failure;
    }

    @Override
    public Retry.RetrySignal copy() {
        return this;
    }

    public String toString() {
        return "attempt #" + (this.failureTotalIndex + 1L) + " (" + (this.failureSubsequentIndex + 1L) + " in a row), last failure={" + this.failure + '}';
    }
}

