/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.io.netty.channel.group.ChannelGroup;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.tcp.TcpServer;
import io.micrometer.shaded.reactor.netty.tcp.TcpServerOperator;
import java.util.Objects;

final class TcpServerChannelGroup
extends TcpServerOperator
implements ConnectionObserver {
    static final AttributeKey<ChannelGroup> CHANNEL_GROUP = AttributeKey.newInstance("channelGroup");
    final ChannelGroup channelGroup;

    TcpServerChannelGroup(TcpServer source, ChannelGroup channelGroup) {
        super(source);
        this.channelGroup = Objects.requireNonNull(channelGroup, "channelGroup");
    }

    @Override
    public ServerBootstrap configure() {
        ServerBootstrap b = this.source.configure();
        b.attr(CHANNEL_GROUP, this.channelGroup);
        ConnectionObserver observer = BootstrapHandlers.childConnectionObserver(b);
        BootstrapHandlers.childConnectionObserver(b, observer.then(this));
        return b;
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == ConnectionObserver.State.CONNECTED) {
            this.channelGroup.add(connection.channel());
        }
    }
}

