/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.ServerChannel;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.io.netty.channel.socket.ServerSocketChannel;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import io.micrometer.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.micrometer.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.resources.ColocatedEventLoopGroup;
import io.micrometer.shaded.reactor.netty.resources.DefaultLoop;
import io.micrometer.shaded.reactor.netty.resources.DefaultLoopNativeDetector;
import io.micrometer.shaded.reactor.netty.resources.DefaultLoopResources;
import java.time.Duration;
import java.util.Objects;

@FunctionalInterface
public interface LoopResources
extends Disposable {
    public static final int DEFAULT_IO_WORKER_COUNT = Integer.parseInt(System.getProperty("io.micrometer.shaded.reactor.netty.ioWorkerCount", "" + Math.max(Runtime.getRuntime().availableProcessors(), 4)));
    public static final int DEFAULT_IO_SELECT_COUNT = Integer.parseInt(System.getProperty("io.micrometer.shaded.reactor.netty.ioSelectCount", "-1"));
    public static final boolean DEFAULT_NATIVE = Boolean.parseBoolean(System.getProperty("io.micrometer.shaded.reactor.netty.native", "true"));
    public static final long DEFAULT_SHUTDOWN_QUIET_PERIOD = Long.parseLong(System.getProperty("io.micrometer.shaded.reactor.netty.ioShutdownQuietPeriod", "2"));
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = Long.parseLong(System.getProperty("io.micrometer.shaded.reactor.netty.ioShutdownTimeout", "15"));

    public static EventLoopGroup colocate(EventLoopGroup group) {
        return new ColocatedEventLoopGroup(group);
    }

    public static LoopResources create(String prefix, int workerCount, boolean daemon) {
        if (workerCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive worker threads number, was: " + workerCount);
        }
        return new DefaultLoopResources(prefix, workerCount, daemon);
    }

    public static LoopResources create(String prefix, int selectCount, int workerCount, boolean daemon) {
        if (Objects.requireNonNull(prefix, "prefix").isEmpty()) {
            throw new IllegalArgumentException("Cannot use empty prefix");
        }
        if (workerCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive worker threads number, was: " + workerCount);
        }
        if (selectCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive selector threads number, was: " + selectCount);
        }
        return new DefaultLoopResources(prefix, selectCount, workerCount, daemon);
    }

    public static LoopResources create(String prefix) {
        return new DefaultLoopResources(prefix, DEFAULT_IO_SELECT_COUNT, DEFAULT_IO_WORKER_COUNT, true);
    }

    @Deprecated
    default public Class<? extends Channel> onChannel(EventLoopGroup group) {
        return this.preferNative() ? this.onChannelClass(SocketChannel.class, group) : NioSocketChannel.class;
    }

    default public <CHANNEL extends Channel> CHANNEL onChannel(Class<CHANNEL> channelType, EventLoopGroup group) {
        DefaultLoop channelFactory = DefaultLoopNativeDetector.INSTANCE.supportGroup(group) ? DefaultLoopNativeDetector.INSTANCE : DefaultLoopNativeDetector.NIO;
        return channelFactory.getChannel(channelType);
    }

    default public <CHANNEL extends Channel> Class<? extends CHANNEL> onChannelClass(Class<CHANNEL> channelType, EventLoopGroup group) {
        DefaultLoop channelFactory = DefaultLoopNativeDetector.INSTANCE.supportGroup(group) ? DefaultLoopNativeDetector.INSTANCE : DefaultLoopNativeDetector.NIO;
        return channelFactory.getChannelClass(channelType);
    }

    default public EventLoopGroup onClient(boolean useNative) {
        return this.onServer(useNative);
    }

    @Deprecated
    default public Class<? extends DatagramChannel> onDatagramChannel(EventLoopGroup group) {
        return this.preferNative() ? this.onChannelClass(DatagramChannel.class, group) : NioDatagramChannel.class;
    }

    public EventLoopGroup onServer(boolean var1);

    @Deprecated
    default public Class<? extends ServerChannel> onServerChannel(EventLoopGroup group) {
        return this.preferNative() ? this.onChannelClass(ServerSocketChannel.class, group) : NioServerSocketChannel.class;
    }

    default public EventLoopGroup onServerSelect(boolean useNative) {
        return this.onServer(useNative);
    }

    @Deprecated
    default public boolean preferNative() {
        return LoopResources.hasNativeSupport();
    }

    default public boolean daemon() {
        return false;
    }

    @Override
    default public void dispose() {
        this.disposeLater().subscribe();
    }

    default public Mono<Void> disposeLater() {
        return this.disposeLater(Duration.ofSeconds(DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(DEFAULT_SHUTDOWN_TIMEOUT));
    }

    default public Mono<Void> disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.empty();
    }

    public static boolean hasNativeSupport() {
        return DefaultLoopNativeDetector.INSTANCE != DefaultLoopNativeDetector.NIO;
    }
}

