/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http;

import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.CookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class Cookies {
    static final int NOT_READ = 0;
    static final int READING = 1;
    static final int READ = 2;
    final HttpHeaders nettyHeaders;
    final CharSequence cookiesHeaderName;
    final boolean isClientChannel;
    final CookieDecoder decoder;
    Map<CharSequence, Set<Cookie>> cachedCookies;
    volatile int state = 0;
    static final AtomicIntegerFieldUpdater<Cookies> STATE = AtomicIntegerFieldUpdater.newUpdater(Cookies.class, "state");

    public static Cookies newClientResponseHolder(HttpHeaders headers, ClientCookieDecoder decoder) {
        return new Cookies(headers, HttpHeaderNames.SET_COOKIE, true, decoder);
    }

    public static Cookies newServerRequestHolder(HttpHeaders headers, ServerCookieDecoder decoder) {
        return new Cookies(headers, HttpHeaderNames.COOKIE, false, decoder);
    }

    private Cookies(HttpHeaders nettyHeaders, CharSequence cookiesHeaderName, boolean isClientChannel, CookieDecoder decoder) {
        this.nettyHeaders = nettyHeaders;
        this.cookiesHeaderName = cookiesHeaderName;
        this.isClientChannel = isClientChannel;
        this.decoder = decoder;
        this.cachedCookies = Collections.emptyMap();
    }

    public Map<CharSequence, Set<Cookie>> getCachedCookies() {
        if (!STATE.compareAndSet(this, 0, 1)) {
            while (this.state != 2) {
            }
            return this.cachedCookies;
        }
        List<String> allCookieHeaders = this.nettyHeaders.getAll(this.cookiesHeaderName);
        HashMap<String, HashSet<Cookie>> cookies = new HashMap<String, HashSet<Cookie>>();
        for (String aCookieHeader : allCookieHeaders) {
            if (this.isClientChannel) {
                Cookie c = ((ClientCookieDecoder)this.decoder).decode(aCookieHeader);
                if (c == null) continue;
                HashSet<Cookie> existingCookiesOfName = (HashSet<Cookie>)cookies.get(c.name());
                if (null == existingCookiesOfName) {
                    existingCookiesOfName = new HashSet<Cookie>();
                    cookies.put(c.name(), existingCookiesOfName);
                }
                existingCookiesOfName.add(c);
                continue;
            }
            Set<Cookie> decode = ((ServerCookieDecoder)this.decoder).decode(aCookieHeader);
            for (Cookie cookie : decode) {
                HashSet<Cookie> existingCookiesOfName = (HashSet<Cookie>)cookies.get(cookie.name());
                if (null == existingCookiesOfName) {
                    existingCookiesOfName = new HashSet<Cookie>();
                    cookies.put(cookie.name(), existingCookiesOfName);
                }
                existingCookiesOfName.add(cookie);
            }
        }
        this.cachedCookies = Collections.unmodifiableMap(cookies);
        this.state = 2;
        return this.cachedCookies;
    }
}

