/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdPollable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class StatsdLongTaskTimer
extends DefaultLongTaskTimer
implements StatsdPollable {
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> subscriber;
    private final AtomicReference<Long> lastActive = new AtomicReference<Long>(Long.MIN_VALUE);
    private final AtomicReference<Double> lastDuration = new AtomicReference<Double>(Double.NEGATIVE_INFINITY);
    private final boolean alwaysPublish;

    StatsdLongTaskTimer(Meter.Id id, StatsdLineBuilder lineBuilder, Subscriber<String> subscriber, Clock clock, boolean alwaysPublish) {
        super(id, clock);
        this.lineBuilder = lineBuilder;
        this.subscriber = subscriber;
        this.alwaysPublish = alwaysPublish;
    }

    @Override
    public void poll() {
        long active = this.activeTasks();
        if (this.alwaysPublish || this.lastActive.getAndSet(active) != active) {
            this.subscriber.onNext(this.lineBuilder.gauge(active, Statistic.ACTIVE_TASKS));
        }
        double duration = this.duration(TimeUnit.MILLISECONDS);
        if (this.alwaysPublish || this.lastDuration.getAndSet(duration) != duration) {
            this.subscriber.onNext(this.lineBuilder.gauge(duration, Statistic.DURATION));
        }
    }
}

