/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SysdigStatsdLineBuilder
extends FlavorStatsdLineBuilder {
    private final Object conventionTagsLock = new Object();
    private volatile NamingConvention namingConvention;
    private volatile String name;
    @Nullable
    private volatile String conventionTags;
    private volatile String tagsNoStat;
    private final ConcurrentMap<Statistic, String> tags = new ConcurrentHashMap<Statistic, String>();
    private static final Pattern NAME_WHITELIST = Pattern.compile("[^\\w._]");

    public SysdigStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config) {
        super(id, config);
    }

    @Override
    String line(String amount, @Nullable Statistic stat, String type) {
        this.updateIfNamingConventionChanged();
        return this.name + this.tagsByStatistic(stat) + ":" + amount + "|" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfNamingConventionChanged() {
        NamingConvention next = this.config.namingConvention();
        if (this.namingConvention != next) {
            this.name = SysdigStatsdLineBuilder.sanitize(next.name(this.id.getName(), this.id.getType(), this.id.getBaseUnit()));
            Object object = this.conventionTagsLock;
            synchronized (object) {
                this.tags.clear();
                this.conventionTags = this.id.getTagsAsIterable().iterator().hasNext() ? this.id.getConventionTags(next).stream().map(t -> SysdigStatsdLineBuilder.sanitize(t.getKey()) + "=" + SysdigStatsdLineBuilder.sanitize(t.getValue())).collect(Collectors.joining(",")) : null;
            }
            this.tagsNoStat = this.tags(null, this.conventionTags, "=", "#");
            this.namingConvention = next;
        }
    }

    private static String sanitize(String name) {
        return NAME_WHITELIST.matcher(name).replaceAll("_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tagsByStatistic(@Nullable Statistic stat) {
        if (stat == null) {
            return this.tagsNoStat;
        }
        String tags = (String)this.tags.get(stat);
        if (tags != null) {
            return tags;
        }
        Object object = this.conventionTagsLock;
        synchronized (object) {
            return this.tags.computeIfAbsent(stat, key -> this.tags(stat, this.conventionTags, "=", "#"));
        }
    }
}

