/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public interface StackdriverConfig
extends StepRegistryConfig {
    default public String prefix() {
        return "stackdriver";
    }

    default public String projectId() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"projectId").required().get();
    }

    default public Map<String, String> resourceLabels() {
        return Collections.emptyMap();
    }

    default public String resourceType() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"resourceType").orElse((Object)"global");
    }

    default public boolean useSemanticMetricTypes() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"useSemanticMetricTypes").orElse((Object)false);
    }

    default public String metricTypePrefix() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"metricTypePrefix").orElse((Object)"custom.googleapis.com/");
    }

    default public CredentialsProvider credentials() {
        return (CredentialsProvider)PropertyValidator.getString((MeterRegistryConfig)this, (String)"credentials").flatMap((credentials, valid) -> {
            if (StringUtils.isBlank((String)credentials)) {
                return Validated.valid((String)valid.getProperty(), (Object)MetricServiceSettings.defaultCredentialsProviderBuilder().build());
            }
            try {
                FixedCredentialsProvider provider = FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream((String)credentials)).createScoped((Collection)MetricServiceSettings.getDefaultServiceScopes()));
                return Validated.valid((String)valid.getProperty(), (Object)provider);
            }
            catch (IOException t) {
                return Validated.invalid((String)valid.getProperty(), (Object)credentials, (String)"cannot read credentials file", (InvalidReason)InvalidReason.MALFORMED, (Throwable)t);
            }
        }).get();
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"projectId", StackdriverConfig::projectId), MeterRegistryConfigValidator.checkRequired((String)"resourceLabels", StackdriverConfig::resourceLabels), MeterRegistryConfigValidator.checkRequired((String)"resourceType", StackdriverConfig::resourceType), MeterRegistryConfigValidator.checkRequired((String)"credentials", StackdriverConfig::credentials)});
    }
}

