/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.WarnThenDebugLogger;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

@Deprecated
public class SignalFxNamingConvention
implements NamingConvention {
    private static final WarnThenDebugLogger logger = new WarnThenDebugLogger(SignalFxNamingConvention.class);
    private static final Pattern PATTERN_TAG_KEY_DENYLISTED_CHARS = Pattern.compile("[^\\w_\\-]");
    private static final int NAME_MAX_LENGTH = 256;
    private static final int TAG_VALUE_MAX_LENGTH = 256;
    private static final int KEY_MAX_LENGTH = 128;
    private final NamingConvention delegate;

    public SignalFxNamingConvention() {
        this(NamingConvention.dot);
    }

    public SignalFxNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String formattedName = StringEscapeUtils.escapeJson((String)this.delegate.name(name, type, baseUnit));
        return StringUtils.truncate((String)formattedName, (int)256);
    }

    public String tagKey(String key) {
        String conventionKey = this.delegate.tagKey(key);
        if ((conventionKey = PATTERN_TAG_KEY_DENYLISTED_CHARS.matcher(conventionKey).replaceAll("_")).isEmpty()) {
            return conventionKey;
        }
        int i = 0;
        while (conventionKey.length() > i) {
            if (conventionKey.startsWith("sf_", i)) {
                i += 3;
                continue;
            }
            if (!conventionKey.startsWith("_", i)) break;
            ++i;
        }
        if (i > 0 && (conventionKey = conventionKey.substring(i)).isEmpty()) {
            return conventionKey;
        }
        if (!Character.isLetter(conventionKey.charAt(0))) {
            logger.log(conventionKey + " doesn't adhere to SignalFx naming standards. Prefixing the tag/dimension key with 'a'.");
            conventionKey = "a" + conventionKey;
        }
        if (conventionKey.startsWith("aws_") || conventionKey.startsWith("gcp_") || conventionKey.startsWith("azure_")) {
            String finalConventionKey = conventionKey;
            logger.log(() -> "'" + finalConventionKey + "' (original name: '" + key + "') is not a valid tag key. Must not start with any of these prefixes: aws_, gcp_, or azure_. Please rename it to conform to the constraints. If it comes from a third party, please use MeterFilter to rename it.");
        }
        return StringUtils.truncate((String)conventionKey, (int)128);
    }

    public String tagValue(String value) {
        String formattedValue = StringEscapeUtils.escapeJson((String)this.delegate.tagValue(value));
        return StringUtils.truncate((String)formattedValue, (int)256);
    }
}

