/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.StepBucketHistogram;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepTimer;
import io.micrometer.signalfx.CumulativeHistogramConfigUtil;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

final class SignalfxTimer
extends StepTimer {
    private final @Nullable StepBucketHistogram stepBucketHistogram;

    SignalfxTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, long stepMillis, boolean isDelta) {
        super(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, stepMillis, SignalfxTimer.defaultHistogram((Clock)clock, (DistributionStatisticConfig)CumulativeHistogramConfigUtil.updateConfig(distributionStatisticConfig, isDelta), (boolean)false));
        double[] slo = distributionStatisticConfig.getServiceLevelObjectiveBoundaries();
        this.stepBucketHistogram = slo != null && slo.length > 0 && isDelta ? new StepBucketHistogram(clock, stepMillis, DistributionStatisticConfig.builder().serviceLevelObjectives(CumulativeHistogramConfigUtil.addPositiveInfBucket(slo)).build().merge(distributionStatisticConfig), false, true) : null;
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        if (this.stepBucketHistogram != null) {
            this.stepBucketHistogram.recordLong(TimeUnit.NANOSECONDS.convert(amount, unit));
        }
        super.recordNonNegative(amount, unit);
    }

    public long count() {
        if (this.stepBucketHistogram != null) {
            this.stepBucketHistogram.poll();
        }
        return super.count();
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot currentSnapshot = super.takeSnapshot();
        if (this.stepBucketHistogram == null) {
            return currentSnapshot;
        }
        return new HistogramSnapshot(currentSnapshot.count(), currentSnapshot.total(), currentSnapshot.max(), currentSnapshot.percentileValues(), (CountAtBucket[])this.stepBucketHistogram.poll(), (arg_0, arg_1) -> ((HistogramSnapshot)currentSnapshot).outputSummary(arg_0, arg_1));
    }
}

