/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.StepBucketHistogram;
import io.micrometer.core.instrument.step.StepDistributionSummary;
import io.micrometer.signalfx.CumulativeHistogramConfigUtil;
import org.jspecify.annotations.Nullable;

final class SignalfxDistributionSummary
extends StepDistributionSummary {
    private final @Nullable StepBucketHistogram stepBucketHistogram;

    SignalfxDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, long stepMillis, boolean isDelta) {
        super(id, clock, distributionStatisticConfig, scale, stepMillis, SignalfxDistributionSummary.defaultHistogram((Clock)clock, (DistributionStatisticConfig)CumulativeHistogramConfigUtil.updateConfig(distributionStatisticConfig, isDelta), (boolean)false));
        double[] slo = distributionStatisticConfig.getServiceLevelObjectiveBoundaries();
        this.stepBucketHistogram = slo != null && slo.length > 0 && isDelta ? new StepBucketHistogram(clock, stepMillis, DistributionStatisticConfig.builder().serviceLevelObjectives(CumulativeHistogramConfigUtil.addPositiveInfBucket(slo)).build().merge(distributionStatisticConfig), false, true) : null;
    }

    protected void recordNonNegative(double amount) {
        if (this.stepBucketHistogram != null) {
            this.stepBucketHistogram.recordDouble(amount);
        }
        super.recordNonNegative(amount);
    }

    public long count() {
        if (this.stepBucketHistogram != null) {
            this.stepBucketHistogram.poll();
        }
        return super.count();
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot currentSnapshot = super.takeSnapshot();
        if (this.stepBucketHistogram == null) {
            return currentSnapshot;
        }
        return new HistogramSnapshot(currentSnapshot.count(), currentSnapshot.total(), currentSnapshot.max(), currentSnapshot.percentileValues(), (CountAtBucket[])this.stepBucketHistogram.poll(), (arg_0, arg_1) -> ((HistogramSnapshot)currentSnapshot).outputSummary(arg_0, arg_1));
    }
}

