/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.registry.otlp.OtlpMetricsSender;
import java.util.Map;

public class OtlpHttpMetricsSender
implements OtlpMetricsSender {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OtlpHttpMetricsSender.class);
    private final HttpSender httpSender;
    private final String userAgentHeader;

    public OtlpHttpMetricsSender(HttpSender httpSender) {
        this.httpSender = httpSender;
        this.userAgentHeader = this.getUserAgentHeader();
    }

    @Override
    public void send(String address, byte[] metricsData, Map<String, String> headers) throws Throwable {
        HttpSender.Request.Builder httpRequest = this.httpSender.post(address).withHeader("User-Agent", this.userAgentHeader).withContent("application/x-protobuf", metricsData);
        headers.forEach((arg_0, arg_1) -> ((HttpSender.Request.Builder)httpRequest).withHeader(arg_0, arg_1));
        HttpSender.Response response = httpRequest.send();
        if (!response.isSuccessful()) {
            throw new OtlpHttpMetricsSendUnsuccessfulException(String.format("Server responded with HTTP status code %d and body %s", response.code(), response.body()));
        }
    }

    private String getUserAgentHeader() {
        String userAgent = "Micrometer-OTLP-Exporter-Java";
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version != null) {
            userAgent = userAgent + "/" + version;
        }
        return userAgent;
    }

    private static class OtlpHttpMetricsSendUnsuccessfulException
    extends RuntimeException {
        public OtlpHttpMetricsSendUnsuccessfulException(String message) {
            super(message);
        }
    }
}

