/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.opentsdb;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class OpenTSDBNamingConvention
implements NamingConvention {
    private static final String SEPARATOR = "_";
    private static final Pattern nameChars = Pattern.compile("[^a-zA-Z0-9_]");
    private static final Pattern tagKeyChars = Pattern.compile("[^a-zA-Z0-9_]");
    private final String timerSuffix;

    public OpenTSDBNamingConvention() {
        this("_duration");
    }

    public OpenTSDBNamingConvention(String timerSuffix) {
        this.timerSuffix = timerSuffix;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String conventionName = NamingConvention.snakeCase.name(name, type, baseUnit);
        switch (type) {
            case COUNTER: 
            case DISTRIBUTION_SUMMARY: 
            case GAUGE: {
                if (baseUnit == null || conventionName.endsWith(SEPARATOR + baseUnit)) break;
                conventionName = conventionName + SEPARATOR + baseUnit;
            }
        }
        switch (type) {
            case COUNTER: {
                if (conventionName.endsWith("_total")) break;
                conventionName = conventionName + "_total";
                break;
            }
            case TIMER: 
            case LONG_TASK_TIMER: {
                if (conventionName.endsWith(this.timerSuffix)) {
                    conventionName = conventionName + "_seconds";
                    break;
                }
                if (conventionName.endsWith("_seconds")) break;
                conventionName = conventionName + this.timerSuffix + "_seconds";
            }
        }
        String sanitized = nameChars.matcher(conventionName).replaceAll(SEPARATOR);
        if (!Character.isLetter(sanitized.charAt(0))) {
            sanitized = "m_" + sanitized;
        }
        return sanitized;
    }

    public String tagKey(String key) {
        String conventionKey = NamingConvention.snakeCase.tagKey(key);
        String sanitized = tagKeyChars.matcher(conventionKey).replaceAll(SEPARATOR);
        if (!Character.isLetter(sanitized.charAt(0))) {
            sanitized = "m_" + sanitized;
        }
        return sanitized;
    }
}

