/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.opentsdb;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.FixedBoundaryVictoriaMetricsHistogram;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.CumulativeHistogramLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.push.PushMeterRegistry;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.opentsdb.OpenTSDBConfig;
import io.micrometer.opentsdb.OpenTSDBDistributionSummary;
import io.micrometer.opentsdb.OpenTSDBFlavor;
import io.micrometer.opentsdb.OpenTSDBNamingConvention;
import io.micrometer.opentsdb.OpenTSDBTimer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTSDBMeterRegistry
extends PushMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("opentsdb-metrics-publisher");
    private final OpenTSDBConfig config;
    private final HttpSender httpClient;
    private final Logger logger = LoggerFactory.getLogger(OpenTSDBMeterRegistry.class);

    public OpenTSDBMeterRegistry(OpenTSDBConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    public OpenTSDBMeterRegistry(OpenTSDBConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((PushRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new OpenTSDBNamingConvention());
        this.config = config;
        this.httpClient = httpClient;
        this.start(threadFactory);
    }

    public static Builder builder(OpenTSDBConfig config) {
        return new Builder(config);
    }

    private static String doubleToGoString(double d) {
        if (d == Double.POSITIVE_INFINITY || d == Double.MAX_VALUE || d == 9.223372036854776E18) {
            return "+Inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        return Double.toString(d);
    }

    public Counter newCounter(Meter.Id id) {
        return new CumulativeCounter(id);
    }

    public DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new OpenTSDBDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.flavor());
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new OpenTSDBTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.config.flavor());
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return new CumulativeHistogramLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new CumulativeFunctionCounter(id, obj, countFunction);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    protected void publish() {
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            try {
                this.httpClient.post(this.config.uri()).withBasicAuthentication(this.config.userName(), this.config.password()).withJsonContent(batch.stream().flatMap(m -> (Stream)m.match(this::writeGauge, this::writeCounter, this::writeTimer, this::writeSummary, this::writeLongTaskTimer, this::writeTimeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeCustomMetric)).collect(Collectors.joining(",", "[", "]"))).compress().send().onSuccess(response -> this.logger.debug("successfully sent {} metrics to opentsdb.", (Object)batch.size())).onError(response -> this.logger.error("failed to send metrics to opentsdb: {}", (Object)response.body()));
            }
            catch (Throwable t) {
                this.logger.warn("failed to send metrics to opentsdb", t);
            }
        }
    }

    Stream<String> writeSummary(DistributionSummary summary) {
        long wallTime = this.config().clock().wallTime();
        ValueAtPercentile[] percentileValues = summary.takeSnapshot().percentileValues();
        CountAtBucket[] histogramCounts = ((OpenTSDBDistributionSummary)summary).histogramCounts();
        double count = summary.count();
        ArrayList<String> metrics = new ArrayList<String>();
        metrics.add(this.writeMetricWithSuffix(summary.getId(), "count", wallTime, count));
        metrics.add(this.writeMetricWithSuffix(summary.getId(), "sum", wallTime, summary.totalAmount()));
        metrics.add(this.writeMetricWithSuffix(summary.getId(), "max", wallTime, summary.max()));
        if (percentileValues.length > 0) {
            metrics.addAll(this.writePercentiles((Meter)summary, wallTime, percentileValues));
        }
        if (histogramCounts.length > 0) {
            metrics.addAll(this.writeHistogram(wallTime, (Meter)summary, histogramCounts, count, this.getBaseTimeUnit()));
        }
        return metrics.stream();
    }

    Stream<String> writeFunctionTimer(FunctionTimer timer) {
        long wallTime = this.config().clock().wallTime();
        return Stream.of(this.writeMetricWithSuffix(timer.getId(), "count", wallTime, timer.count()), this.writeMetricWithSuffix(timer.getId(), "sum", wallTime, timer.totalTime(this.getBaseTimeUnit())));
    }

    Stream<String> writeTimer(Timer timer) {
        long wallTime = this.config().clock().wallTime();
        HistogramSnapshot histogramSnapshot = timer.takeSnapshot();
        ValueAtPercentile[] percentileValues = histogramSnapshot.percentileValues();
        CountAtBucket[] histogramCounts = histogramSnapshot.histogramCounts();
        double count = timer.count();
        ArrayList<String> metrics = new ArrayList<String>();
        metrics.add(this.writeMetricWithSuffix(timer.getId(), "count", wallTime, count));
        metrics.add(this.writeMetricWithSuffix(timer.getId(), "sum", wallTime, timer.totalTime(this.getBaseTimeUnit())));
        metrics.add(this.writeMetricWithSuffix(timer.getId(), "max", wallTime, timer.max(this.getBaseTimeUnit())));
        if (percentileValues.length > 0) {
            metrics.addAll(this.writePercentiles((Meter)timer, wallTime, percentileValues));
        }
        if (histogramCounts.length > 0) {
            metrics.addAll(this.writeHistogram(wallTime, (Meter)timer, histogramCounts, count, this.getBaseTimeUnit()));
        }
        return metrics.stream();
    }

    private List<String> writePercentiles(Meter meter, long wallTime, ValueAtPercentile[] percentileValues) {
        ArrayList<String> metrics = new ArrayList<String>(percentileValues.length);
        boolean forTimer = meter instanceof Timer;
        for (ValueAtPercentile v : percentileValues) {
            metrics.add(this.writeMetric(meter.getId().withTag((Tag)new ImmutableTag("quantile", OpenTSDBMeterRegistry.doubleToGoString(v.percentile()))), wallTime, forTimer ? v.value(this.getBaseTimeUnit()) : v.value()));
        }
        return metrics;
    }

    private List<String> writeHistogram(long wallTime, Meter meter, CountAtBucket[] histogramCounts, double count, @Nullable TimeUnit timeUnit) {
        ArrayList<String> metrics = new ArrayList<String>(histogramCounts.length);
        if (this.config.flavor() == null) {
            for (CountAtBucket c : histogramCounts) {
                metrics.add(this.writeMetricWithSuffix(meter.getId().withTag((Tag)new ImmutableTag("le", OpenTSDBMeterRegistry.doubleToGoString(timeUnit == null ? c.bucket() : c.bucket(timeUnit)))), "bucket", wallTime, c.count()));
            }
            metrics.add(this.writeMetricWithSuffix(meter.getId().withTag((Tag)new ImmutableTag("le", "+Inf")), "bucket", wallTime, count));
        } else if (OpenTSDBFlavor.VictoriaMetrics.equals((Object)this.config.flavor())) {
            for (CountAtBucket c : histogramCounts) {
                metrics.add(this.writeMetricWithSuffix(meter.getId().withTag(Tag.of((String)"vmrange", (String)FixedBoundaryVictoriaMetricsHistogram.getRangeTagValue((double)(timeUnit == null ? c.bucket() : c.bucket(timeUnit))))), "bucket", wallTime, c.count()));
            }
        }
        return metrics;
    }

    Stream<String> writeFunctionCounter(FunctionCounter counter) {
        double count = counter.count();
        if (Double.isFinite(count)) {
            return Stream.of(this.writeMetric(counter.getId(), this.config().clock().wallTime(), count));
        }
        return Stream.empty();
    }

    Stream<String> writeCounter(Counter counter) {
        return Stream.of(this.writeMetric(counter.getId(), this.config().clock().wallTime(), counter.count()));
    }

    Stream<String> writeGauge(Gauge gauge) {
        double value = gauge.value();
        if (Double.isFinite(value)) {
            return Stream.of(this.writeMetric(gauge.getId(), this.config().clock().wallTime(), value));
        }
        return Stream.empty();
    }

    Stream<String> writeTimeGauge(TimeGauge timeGauge) {
        double value = timeGauge.value(this.getBaseTimeUnit());
        if (Double.isFinite(value)) {
            return Stream.of(this.writeMetric(timeGauge.getId(), this.config().clock().wallTime(), value));
        }
        return Stream.empty();
    }

    Stream<String> writeLongTaskTimer(LongTaskTimer timer) {
        long wallTime = this.config().clock().wallTime();
        HistogramSnapshot histogramSnapshot = timer.takeSnapshot();
        ValueAtPercentile[] percentileValues = histogramSnapshot.percentileValues();
        CountAtBucket[] histogramCounts = histogramSnapshot.histogramCounts();
        double count = timer.activeTasks();
        ArrayList<String> metrics = new ArrayList<String>();
        metrics.add(this.writeMetricWithSuffix(timer.getId(), "active.count", wallTime, count));
        metrics.add(this.writeMetricWithSuffix(timer.getId(), "duration.sum", wallTime, timer.duration(this.getBaseTimeUnit())));
        metrics.add(this.writeMetricWithSuffix(timer.getId(), "max", wallTime, timer.max(this.getBaseTimeUnit())));
        if (percentileValues.length > 0) {
            metrics.addAll(this.writePercentiles((Meter)timer, wallTime, percentileValues));
        }
        if (histogramCounts.length > 0) {
            metrics.addAll(this.writeHistogram(wallTime, (Meter)timer, histogramCounts, count, this.getBaseTimeUnit()));
        }
        return metrics.stream();
    }

    private Stream<String> writeCustomMetric(Meter meter) {
        long wallTime = this.config().clock().wallTime();
        List tags = this.getConventionTags(meter.getId());
        return StreamSupport.stream(meter.measure().spliterator(), false).map(ms -> {
            Tags localTags = Tags.concat((Iterable)tags, (String[])new String[]{"statistics", ms.getStatistic().toString()});
            String name = this.getConventionName(meter.getId());
            switch (ms.getStatistic()) {
                case TOTAL: 
                case TOTAL_TIME: {
                    name = name + ".sum";
                    break;
                }
                case MAX: {
                    name = name + ".max";
                    break;
                }
                case ACTIVE_TASKS: {
                    name = name + ".active.count";
                    break;
                }
                case DURATION: {
                    name = name + ".duration.sum";
                }
            }
            return new OpenTSDBMetricBuilder().field("metric", name).datapoints(wallTime, ms.getValue()).tags((Iterable<Tag>)localTags).build();
        });
    }

    String writeMetricWithSuffix(Meter.Id id, String suffix, long wallTime, double value) {
        return new OpenTSDBMetricBuilder().field("metric", suffix.isEmpty() ? this.getConventionName(id) : this.config().namingConvention().tagKey(this.getConventionName(id) + "." + suffix)).datapoints(wallTime, value).tags(this.getConventionTags(id)).build();
    }

    String writeMetric(Meter.Id id, long wallTime, double value) {
        return this.writeMetricWithSuffix(id, "", wallTime, value);
    }

    static /* synthetic */ ThreadFactory access$100() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final OpenTSDBConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = OpenTSDBMeterRegistry.access$100();
        private HttpSender httpClient;

        Builder(OpenTSDBConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public OpenTSDBMeterRegistry build() {
            return new OpenTSDBMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }

    private static class OpenTSDBMetricBuilder {
        private final StringBuilder sb = new StringBuilder("{");

        private OpenTSDBMetricBuilder() {
        }

        OpenTSDBMetricBuilder field(String key, String value) {
            if (this.sb.length() > 1) {
                this.sb.append(',');
            }
            this.sb.append('\"').append(StringEscapeUtils.escapeJson((String)key)).append("\":\"").append(StringEscapeUtils.escapeJson((String)value)).append('\"');
            return this;
        }

        OpenTSDBMetricBuilder datapoints(long wallTime, double value) {
            this.sb.append(",\"timestamp\":").append(wallTime).append(",\"value\":").append(DoubleFormat.wholeOrDecimal((double)value));
            return this;
        }

        OpenTSDBMetricBuilder tags(Iterable<Tag> tags) {
            OpenTSDBMetricBuilder tagBuilder = new OpenTSDBMetricBuilder();
            if (!tags.iterator().hasNext()) {
                try {
                    tagBuilder.field("host", InetAddress.getLocalHost().getHostName());
                }
                catch (UnknownHostException unknownHostException) {}
            } else {
                for (Tag tag : tags) {
                    tagBuilder.field(tag.getKey(), tag.getValue());
                }
            }
            this.sb.append(",\"tags\":").append(tagBuilder.build());
            return this;
        }

        String build() {
            return this.sb.append('}').toString();
        }
    }
}

