/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.newrelic.ClientProviderType;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public interface NewRelicConfig
extends StepRegistryConfig {
    default public String prefix() {
        return "newrelic";
    }

    default public boolean meterNameEventTypeEnabled() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"meterNameEventTypeEnabled").orElse((Object)false);
    }

    default public String eventType() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"eventType").orElse((Object)"MicrometerSample");
    }

    default public ClientProviderType clientProviderType() {
        return (ClientProviderType)((Object)PropertyValidator.getEnum((MeterRegistryConfig)this, ClientProviderType.class, (String)"clientProviderType").orElse((Object)ClientProviderType.INSIGHTS_API));
    }

    default public @Nullable String apiKey() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"apiKey").invalidateWhen(secret -> StringUtils.isBlank((String)secret) && ClientProviderType.INSIGHTS_API.equals((Object)this.clientProviderType()), "is required when publishing to Insights API", InvalidReason.MISSING).orElse(null);
    }

    default public @Nullable String accountId() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"accountId").invalidateWhen(secret -> StringUtils.isBlank((String)secret) && ClientProviderType.INSIGHTS_API.equals((Object)this.clientProviderType()), "is required when publishing to Insights API", InvalidReason.MISSING).orElse(null);
    }

    default public String uri() {
        return (String)PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"uri").orElse((Object)"https://insights-collector.newrelic.com");
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.check((String)"eventType", NewRelicConfig::eventType).andThen(v -> v.invalidateWhen(type -> StringUtils.isBlank((String)type) && !this.meterNameEventTypeEnabled(), "event type is required when not using the meter name as the event type", InvalidReason.MISSING)), MeterRegistryConfigValidator.checkRequired((String)"clientProviderType", NewRelicConfig::clientProviderType)});
    }

    default public Validated<?> validateForInsightsApi() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> this.validate(), MeterRegistryConfigValidator.check((String)"uri", NewRelicConfig::uri).andThen(v -> v.invalidateWhen(StringUtils::isBlank, "is required when publishing to Insights API", InvalidReason.MISSING)), MeterRegistryConfigValidator.check((String)"apiKey", NewRelicConfig::apiKey).andThen(v -> v.invalidateWhen(StringUtils::isBlank, "is required when publishing to Insights API", InvalidReason.MISSING)), MeterRegistryConfigValidator.check((String)"accountId", NewRelicConfig::accountId).andThen(v -> v.invalidateWhen(StringUtils::isBlank, "is required when publishing to Insights API", InvalidReason.MISSING))});
    }
}

