/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.ganglia;

import com.codahale.metrics.MetricRegistry;
import info.ganglia.gmetric4j.gmetric.GMetric;
import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import info.ganglia.gmetric4j.gmetric.GangliaException;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.ganglia.GangliaConfig;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("ganglia-metrics-publisher");
    private final Logger logger = LoggerFactory.getLogger(GangliaMeterRegistry.class);
    private final GangliaConfig config;
    private final HierarchicalNameMapper nameMapper;
    private final GMetric ganglia;

    public GangliaMeterRegistry(GangliaConfig config, Clock clock) {
        this(config, clock, HierarchicalNameMapper.DEFAULT, DEFAULT_THREAD_FACTORY);
    }

    @Deprecated
    public GangliaMeterRegistry(GangliaConfig config, Clock clock, HierarchicalNameMapper nameMapper) {
        this(config, clock, nameMapper, DEFAULT_THREAD_FACTORY);
    }

    private GangliaMeterRegistry(GangliaConfig config, Clock clock, HierarchicalNameMapper nameMapper, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.nameMapper = nameMapper;
        this.config().namingConvention(NamingConvention.camelCase);
        try {
            this.ganglia = new GMetric(config.host(), config.port(), config.addressingMode(), config.ttl());
            this.start(threadFactory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to configure Ganglia metrics reporting", e);
        }
    }

    @Deprecated
    public GangliaMeterRegistry(GangliaConfig config, Clock clock, HierarchicalNameMapper nameMapper, MetricRegistry metricRegistry) {
        this(config, clock, nameMapper);
    }

    public static Builder builder(GangliaConfig config) {
        return new Builder(config);
    }

    protected void publish() {
        for (Meter meter : this.getMeters()) {
            meter.use(this::announceGauge, this::announceCounter, this::announceTimer, this::announceSummary, this::announceLongTaskTimer, this::announceTimeGauge, this::announceFunctionCounter, this::announceFunctionTimer, this::announceMeter);
        }
    }

    private void announceMeter(Meter meter) {
        for (Measurement measurement : meter.measure()) {
            this.announce(meter, measurement.getValue(), measurement.getStatistic().toString().toLowerCase(Locale.ROOT));
        }
    }

    private void announceFunctionTimer(FunctionTimer functionTimer) {
        this.announce((Meter)functionTimer, functionTimer.count(), "count");
        this.announce((Meter)functionTimer, functionTimer.totalTime(this.getBaseTimeUnit()), "sum");
        this.announce((Meter)functionTimer, functionTimer.mean(this.getBaseTimeUnit()), "avg");
    }

    private void announceFunctionCounter(FunctionCounter functionCounter) {
        this.announce((Meter)functionCounter, functionCounter.count());
    }

    private void announceTimeGauge(TimeGauge timeGauge) {
        this.announce((Meter)timeGauge, timeGauge.value(this.getBaseTimeUnit()));
    }

    private void announceLongTaskTimer(LongTaskTimer longTaskTimer) {
        this.announce((Meter)longTaskTimer, longTaskTimer.activeTasks(), "activeTasks");
        this.announce((Meter)longTaskTimer, longTaskTimer.duration(this.getBaseTimeUnit()), "duration");
    }

    private void announceSummary(DistributionSummary summary) {
        HistogramSnapshot snapshot = summary.takeSnapshot();
        this.announce((Meter)summary, snapshot.count(), "count");
        this.announce((Meter)summary, snapshot.total(), "sum");
        this.announce((Meter)summary, snapshot.mean(), "avg");
        this.announce((Meter)summary, snapshot.max(), "max");
    }

    private void announceTimer(Timer timer) {
        HistogramSnapshot snapshot = timer.takeSnapshot();
        this.announce((Meter)timer, snapshot.count(), "count");
        this.announce((Meter)timer, snapshot.total(this.getBaseTimeUnit()), "sum");
        this.announce((Meter)timer, snapshot.mean(this.getBaseTimeUnit()), "avg");
        this.announce((Meter)timer, snapshot.max(this.getBaseTimeUnit()), "max");
    }

    private void announceCounter(Counter counter) {
        this.announce((Meter)counter, counter.count());
    }

    private void announceGauge(Gauge gauge) {
        this.announce((Meter)gauge, gauge.value());
    }

    private void announce(Meter meter, double value) {
        this.announce(meter, value, null);
    }

    private void announce(Meter meter, double value, @Nullable String suffix) {
        Meter.Id id = meter.getId();
        String baseUnit = id.getBaseUnit();
        try {
            this.ganglia.announce(this.getMetricName(id, suffix), DoubleFormat.decimalOrNan((double)value), GMetricType.DOUBLE, baseUnit == null ? "" : baseUnit, GMetricSlope.BOTH, (int)this.config.step().getSeconds(), 0, "MICROMETER");
        }
        catch (GangliaException e) {
            this.logger.warn("Unable to publish metric " + id.getName() + " to ganglia", (Throwable)e);
        }
    }

    String getMetricName(Meter.Id id, @Nullable String suffix) {
        return this.nameMapper.toHierarchicalName(id.withName(suffix != null ? id.getName() + "." + suffix : id.getName()), this.config().namingConvention());
    }

    protected TimeUnit getBaseTimeUnit() {
        return this.config.durationUnits();
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final GangliaConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = GangliaMeterRegistry.access$000();
        private HierarchicalNameMapper nameMapper = HierarchicalNameMapper.DEFAULT;

        Builder(GangliaConfig config) {
            this.config = config;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder nameMapper(HierarchicalNameMapper nameMapper) {
            this.nameMapper = nameMapper;
            return this;
        }

        public GangliaMeterRegistry build() {
            return new GangliaMeterRegistry(this.config, this.clock, this.nameMapper, this.threadFactory);
        }
    }
}

