/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.elastic;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public interface ElasticConfig
extends StepRegistryConfig {
    public static final ElasticConfig DEFAULT = k -> null;

    public @Nullable String get(String var1);

    default public String prefix() {
        return "elastic";
    }

    default public String host() {
        return (String)PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"host").orElse((Object)"http://localhost:9200");
    }

    default public String index() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"index").orElse((Object)"micrometer-metrics");
    }

    default public String indexDateFormat() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"indexDateFormat").invalidateWhen(format -> {
            if (format == null) {
                return false;
            }
            try {
                DateTimeFormatter.ofPattern(format);
                return false;
            }
            catch (IllegalArgumentException ignored) {
                return true;
            }
        }, "invalid date format", InvalidReason.MALFORMED).orElse((Object)"yyyy-MM");
    }

    default public String timestampFieldName() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"timestampFieldName").orElse((Object)"@timestamp");
    }

    default public boolean autoCreateIndex() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"autoCreateIndex").orElse((Object)true);
    }

    default public @Nullable String userName() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"userName").orElse(null);
    }

    default public @Nullable String password() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"password").orElse(null);
    }

    default public @Nullable String pipeline() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"pipeline").orElse(null);
    }

    default public String indexDateSeparator() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"indexDateSeparator").orElse((Object)"-");
    }

    default public @Nullable String apiKeyCredentials() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"apiKeyCredentials").orElse(null);
    }

    @Deprecated
    default public String documentType() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"documentType").orElse((Object)"doc");
    }

    default public boolean enableSource() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"enableSource").orElse((Object)false);
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"host", ElasticConfig::host), MeterRegistryConfigValidator.checkRequired((String)"index", ElasticConfig::index), MeterRegistryConfigValidator.checkRequired((String)"timestampFieldName", ElasticConfig::timestampFieldName), MeterRegistryConfigValidator.checkRequired((String)"indexDateFormat", ElasticConfig::indexDateFormat).andThen(v -> v.invalidateWhen(format -> {
            if (format == null) {
                return true;
            }
            try {
                DateTimeFormatter.ofPattern(format);
                return false;
            }
            catch (IllegalArgumentException ignored) {
                return true;
            }
        }, "invalid date format", InvalidReason.MALFORMED)), MeterRegistryConfigValidator.checkRequired((String)"indexDateSeparator", ElasticConfig::indexDateSeparator), MeterRegistryConfigValidator.checkRequired((String)"documentType", ElasticConfig::documentType)});
    }
}

