/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace.v1;

import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class DynatraceMetricDefinition {
    private static final int MAX_DISPLAY_NAME = 256;
    private static final int MAX_GROUP_NAME = 256;
    private final String metricId;
    @Nullable
    private final String description;
    @Nullable
    private final DynatraceUnit unit;
    @Nullable
    private final Set<String> dimensions;
    private final String[] technologyTypes;
    @Nullable
    private final String group;

    DynatraceMetricDefinition(String metricId, @Nullable String description, @Nullable DynatraceUnit unit, @Nullable Set<String> dimensions, String[] technologyTypes, String group) {
        this.metricId = metricId;
        this.description = description;
        this.unit = unit;
        this.dimensions = dimensions;
        this.technologyTypes = technologyTypes;
        this.group = group;
    }

    String getMetricId() {
        return this.metricId;
    }

    String asJson() {
        String displayName = this.description == null ? this.metricId : StringEscapeUtils.escapeJson((String)this.description);
        String body = "{\"displayName\":\"" + StringUtils.truncate((String)displayName, (int)256) + "\"";
        if (StringUtils.isNotBlank((String)this.group)) {
            body = body + ",\"group\":\"" + StringUtils.truncate((String)this.group, (int)256) + "\"";
        }
        if (this.unit != null) {
            body = body + ",\"unit\":\"" + (Object)((Object)this.unit) + "\"";
        }
        if (this.dimensions != null && !this.dimensions.isEmpty()) {
            body = body + ",\"dimensions\":[" + this.dimensions.stream().map(d -> "\"" + d + "\"").collect(Collectors.joining(",")) + "]";
        }
        body = body + ",\"types\":[" + Arrays.stream(this.technologyTypes).map(type -> "\"" + type + "\"").collect(Collectors.joining(",")) + "]";
        body = body + "}";
        return body;
    }

    static enum DynatraceUnit {
        NanoSecond,
        MicroSecond,
        MilliSecond,
        Second,
        Bit,
        Byte,
        KiloByte,
        KibiByte,
        MegaByte,
        MebiByte,
        GigaByte,
        GibiByte,
        Count;

        private static Map<String, DynatraceUnit> UNITS_MAPPING;

        @Nullable
        static DynatraceUnit fromPlural(@Nullable String plural) {
            return UNITS_MAPPING.getOrDefault(plural, null);
        }

        static {
            UNITS_MAPPING = Collections.unmodifiableMap(Stream.of(DynatraceUnit.values()).collect(Collectors.toMap(k -> k.toString().toLowerCase() + "s", Function.identity())));
        }
    }
}

