/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.appoptics;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import java.util.regex.Pattern;

public class AppOpticsNamingConvention
implements NamingConvention {
    private static final int MAX_NAME_LENGTH = 255;
    private static final int MAX_TAG_KEY_LENGTH = 64;
    private static final int MAX_TAG_VALUE_LENGTH = 255;
    private static final Pattern NAME_BLACKLIST = Pattern.compile("[^-.:\\w]");
    private static final Pattern TAG_KEY_BLACKLIST = Pattern.compile("[^-.:\\w]");
    private static final Pattern TAG_VALUE_BLACKLIST = Pattern.compile("[^-.:\\w?\\\\/ ]");
    private final NamingConvention delegate;

    public AppOpticsNamingConvention() {
        this(NamingConvention.dot);
    }

    public AppOpticsNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String sanitized = NAME_BLACKLIST.matcher(this.delegate.name(name, type, baseUnit)).replaceAll("_");
        return StringUtils.truncate((String)sanitized, (int)255);
    }

    public String tagKey(String key) {
        String sanitized = TAG_KEY_BLACKLIST.matcher(this.delegate.tagKey(key)).replaceAll("_");
        return StringUtils.truncate((String)sanitized, (int)64);
    }

    public String tagValue(String value) {
        String sanitized = TAG_VALUE_BLACKLIST.matcher(this.delegate.tagValue(value)).replaceAll("_");
        return StringUtils.truncate((String)sanitized, (int)255);
    }
}

