/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

public abstract class ObservationRegistryCompatibilityKit {
    private ObservationRegistry registry;

    public abstract ObservationRegistry registry();

    @BeforeEach
    void setup() {
        this.registry = this.registry();
    }

    @Test
    @DisplayName(value="observe using handlers")
    void observeWithHandlers() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        ObservationHandler handlerThatHandlesNothing = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        this.registry.observationConfig().observationHandler(handler);
        this.registry.observationConfig().observationHandler(handlerThatHandlesNothing);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)handlerThatHandlesNothing.supportsContext((Observation.Context)ArgumentMatchers.any())).thenReturn((Object)false);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler, handlerThatHandlesNothing});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handlerThatHandlesNothing)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerThatHandlesNothing});
        try (Observation.Scope scope = observation.openScope();){
            ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
            Assertions.assertThat((Object)scope.getCurrentObservation()).isSameAs((Object)observation);
            Observation.Event event = Observation.Event.of((String)"testEvent", (String)"event for testing");
            observation.event(event);
            Observation.Event event2 = Observation.Event.of((String)"testEvent", (String)"event for testing", (long)System.currentTimeMillis());
            observation.event(event2);
            ((ObservationHandler)inOrder.verify((Object)handler)).onEvent((Observation.Event)Mockito.same((Object)event), (Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
            ((ObservationHandler)inOrder.verify((Object)handler)).onEvent((Observation.Event)Mockito.same((Object)event2), (Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
            IOException exception = new IOException("simulated");
            observation.error((Throwable)exception);
            ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        }
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        observation.stop();
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void runnableShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Runnable runnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
        observation.observe(runnable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void wrappedRunnableShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Runnable runnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
        observation.wrap(runnable).run();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void runnableThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Runnable runnable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new RuntimeException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.observe(runnable)).isInstanceOf(RuntimeException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void wrappedRunnableThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Runnable runnable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new RuntimeException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.wrap(runnable).run()).isInstanceOf(RuntimeException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void checkedRunnableShouldBeObserved() throws Throwable {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedRunnable checkedRunnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
        observation.observeChecked(checkedRunnable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void wrappedCheckedRunnableShouldBeObserved() throws Throwable {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedRunnable checkedRunnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
        observation.wrapChecked(checkedRunnable).run();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void checkedRunnableThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedRunnable checkedRunnable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new IOException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.observeChecked(checkedRunnable)).isInstanceOf(IOException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void wrappedCheckedRunnableThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedRunnable checkedRunnable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new IOException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.wrapChecked(checkedRunnable).run()).isInstanceOf(IOException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void supplierShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Supplier<String> supplier = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            return "test";
        };
        String result = (String)observation.observe(supplier);
        Assertions.assertThat((String)result).isEqualTo("test");
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void wrappedSupplierShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Supplier<String> supplier = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            return "test";
        };
        String result = (String)observation.wrap(supplier).get();
        Assertions.assertThat((String)result).isEqualTo("test");
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void supplierThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Supplier<String> supplier = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new RuntimeException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.observe(supplier)).isInstanceOf(RuntimeException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void wrappedSupplierThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Supplier<String> supplier = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new RuntimeException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.wrap(supplier).get()).isInstanceOf(RuntimeException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void callableShouldBeObserved() throws Throwable {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedCallable callable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            return "test";
        };
        String result = (String)observation.observeChecked(callable);
        Assertions.assertThat((String)result).isEqualTo("test");
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void wrappedCallableShouldBeObserved() throws Throwable {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedCallable callable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            return "test";
        };
        String result = (String)observation.wrapChecked(callable).call();
        Assertions.assertThat((String)result).isEqualTo("test");
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void callableThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedCallable callable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new IOException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.observeChecked(callable)).isInstanceOf(IOException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void wrappedCallableThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedCallable callable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new IOException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.wrapChecked(callable).call()).isInstanceOf(IOException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void functionShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Function<Observation.Context, String> function = context -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            Assertions.assertThat((Object)context).isSameAs((Object)observation.getContext());
            return "test";
        };
        String result = (String)observation.observeWithContext(function);
        Assertions.assertThat((String)result).isEqualTo("test");
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void functionThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Function<Observation.Context, String> function = context -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new RuntimeException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.observeWithContext(function)).isInstanceOf(RuntimeException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void checkedFunctionShouldBeObserved() throws Throwable {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedFunction function = context -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            Assertions.assertThat((Object)context).isSameAs((Object)observation.getContext());
            return "test";
        };
        String result = (String)observation.observeCheckedWithContext(function);
        Assertions.assertThat((String)result).isEqualTo("test");
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void checkedFunctionThrowingErrorShouldBeObserved() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedFunction function = context -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw new IOException("simulated");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> observation.observeCheckedWithContext(function)).isInstanceOf(IOException.class)).hasMessage("simulated").hasNoCause();
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStart((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void runnableShouldBeScoped() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        Runnable runnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
        observation.scoped(runnable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Assertions.assertThat((Throwable)observation.getContext().getError()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void errorShouldBeReportedOnFailingScopedRunnable() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        RuntimeException error = new RuntimeException("simulated");
        Runnable runnable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw error;
        };
        Assertions.assertThatThrownBy(() -> observation.scoped(runnable)).isSameAs((Object)error);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Assertions.assertThat((Throwable)observation.getContext().getError()).isSameAs((Object)error);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void checkedRunnableShouldBeScoped() throws Throwable {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedRunnable checkedRunnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
        observation.scopedChecked(checkedRunnable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Assertions.assertThat((Throwable)observation.getContext().getError()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void errorShouldBeReportedOnFailingScopedCheckedRunnable() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        RuntimeException error = new RuntimeException("simulated");
        Observation.CheckedRunnable checkedRunnable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw error;
        };
        Assertions.assertThatThrownBy(() -> observation.scopedChecked(checkedRunnable)).isSameAs((Object)error);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Assertions.assertThat((Throwable)observation.getContext().getError()).isSameAs((Object)error);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void supplierShouldBeScoped() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        Supplier<String> supplier = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            return "test";
        };
        String result = (String)observation.scoped(supplier);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Assertions.assertThat((String)result).isEqualTo("test");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void errorShouldBeReportedOnFailingScopedSupplier() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        RuntimeException error = new RuntimeException("simulated");
        Supplier<String> supplier = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw error;
        };
        Assertions.assertThatThrownBy(() -> observation.scoped(supplier)).isSameAs((Object)error);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Assertions.assertThat((Throwable)observation.getContext().getError()).isSameAs((Object)error);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void checkedCallableShouldBeScoped() throws IOException {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedCallable callable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            return "test";
        };
        String result = (String)observation.scopedChecked(callable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Assertions.assertThat((String)result).isEqualTo("test");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void errorShouldBeReportedOnFailingScopedCheckedCallable() {
        ObservationHandler handler = (ObservationHandler)Mockito.mock(ObservationHandler.class);
        Mockito.when((Object)handler.supportsContext((Observation.Context)ArgumentMatchers.isA(Observation.Context.class))).thenReturn((Object)true);
        this.registry.observationConfig().observationHandler(handler);
        Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        RuntimeException error = new RuntimeException("simulated");
        Observation.CheckedCallable callable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)observation);
            throw error;
        };
        Assertions.assertThatThrownBy(() -> observation.scopedChecked(callable)).isSameAs((Object)error);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Assertions.assertThat((Throwable)observation.getContext().getError()).isSameAs((Object)error);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeOpened((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onScopeClosed((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler)).onError((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
        ((ObservationHandler)inOrder.verify((Object)handler, Mockito.times((int)0))).onStop((Observation.Context)ArgumentMatchers.isA(Observation.Context.class));
    }

    @Test
    void runnableShouldBeParentScoped() {
        this.registry.observationConfig().observationHandler(c -> true);
        Observation parent = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        Runnable runnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)parent);
        Observation.tryScoped((Observation)parent, (Runnable)runnable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
    }

    @Test
    void runnableShouldNotBeParentScopedIfParentIsNull() {
        Runnable runnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Observation.tryScoped(null, (Runnable)runnable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
    }

    @Test
    void checkedRunnableShouldBeParentScoped() throws Throwable {
        this.registry.observationConfig().observationHandler(c -> true);
        Observation parent = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedRunnable checkedRunnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)parent);
        Observation.tryScopedChecked((Observation)parent, (Observation.CheckedRunnable)checkedRunnable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
    }

    @Test
    void checkedRunnableShouldNotBeParentScopedIfParentIsNull() throws Throwable {
        Observation.CheckedRunnable checkedRunnable = () -> Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
        Observation.tryScopedChecked(null, (Observation.CheckedRunnable)checkedRunnable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
    }

    @Test
    void supplierShouldBeParentScoped() {
        this.registry.observationConfig().observationHandler(c -> true);
        Observation parent = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        Supplier<String> supplier = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)parent);
            return "test";
        };
        String result = (String)Observation.tryScoped((Observation)parent, supplier);
        Assertions.assertThat((String)result).isEqualTo("test");
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
    }

    @Test
    void supplierShouldNotBeParentScopedIfParentIsNull() {
        Supplier<String> supplier = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
            return "test";
        };
        Observation.tryScoped(null, supplier);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
    }

    @Test
    void checkedCallableShouldBeParentScoped() throws Throwable {
        this.registry.observationConfig().observationHandler(c -> true);
        Observation parent = Observation.start((String)"myObservation", (ObservationRegistry)this.registry);
        Observation.CheckedCallable callable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isSameAs((Object)parent);
            return "test";
        };
        String result = (String)Observation.tryScopedChecked((Observation)parent, (Observation.CheckedCallable)callable);
        Assertions.assertThat((String)result).isEqualTo("test");
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
    }

    @Test
    void checkedCallableShouldNotBeParentScopedIfParentIsNull() throws Throwable {
        Observation.CheckedCallable callable = () -> {
            Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
            return "test";
        };
        Observation.tryScopedChecked(null, (Observation.CheckedCallable)callable);
        Assertions.assertThat((Object)this.registry.getCurrentObservation()).isNull();
    }

    @Test
    void observationFieldsShouldBeSetOnContext() {
        AssertingHandler assertingHandler = new AssertingHandler();
        this.registry.observationConfig().observationConvention((GlobalObservationConvention)new TestObservationConvention("global")).observationConvention((GlobalObservationConvention)new UnsupportedObservationConvention("global")).observationHandler((ObservationHandler)assertingHandler);
        TestContext testContext = new TestContext();
        testContext.put("context.field", "42");
        IOException exception = new IOException("simulated");
        Observation observation = Observation.createNotStarted((String)"test.observation", () -> testContext, (ObservationRegistry)this.registry).lowCardinalityKeyValue("lcTag1", "0").lowCardinalityKeyValue("lcTag1", "1").lowCardinalityKeyValues(KeyValues.of((String)"lcTag2", (String)"2")).highCardinalityKeyValue("hcTag1", "0").highCardinalityKeyValue("hcTag1", "3").highCardinalityKeyValues(KeyValues.of((String)"hcTag2", (String)"4")).contextualName("test.observation.42").error((Throwable)exception).start();
        observation.stop();
        assertingHandler.checkAssertions(context -> {
            Assertions.assertThat((Object)context).isSameAs((Object)testContext);
            Assertions.assertThat((String)context.getName()).isEqualTo("test.observation");
            Assertions.assertThat((Iterable)context.getLowCardinalityKeyValues()).containsExactlyInAnyOrder((Object[])new KeyValue[]{KeyValue.of((String)"lcTag1", (String)"1"), KeyValue.of((String)"lcTag2", (String)"2"), KeyValue.of((String)"global.context.class", (String)"TestContext")});
            Assertions.assertThat((Iterable)context.getHighCardinalityKeyValues()).containsExactlyInAnyOrder((Object[])new KeyValue[]{KeyValue.of((String)"hcTag1", (String)"3"), KeyValue.of((String)"hcTag2", (String)"4"), KeyValue.of((String)"global.uuid", (String)testContext.uuid)});
            Assertions.assertThat((Iterable)context.getAllKeyValues()).containsExactlyInAnyOrder((Object[])new KeyValue[]{KeyValue.of((String)"lcTag1", (String)"1"), KeyValue.of((String)"lcTag2", (String)"2"), KeyValue.of((String)"global.context.class", (String)"TestContext"), KeyValue.of((String)"hcTag1", (String)"3"), KeyValue.of((String)"hcTag2", (String)"4"), KeyValue.of((String)"global.uuid", (String)testContext.uuid)});
            Assertions.assertThat((String)((String)context.get((Object)"context.field"))).isEqualTo("42");
            Assertions.assertThat((String)context.getContextualName()).isEqualTo("test.observation.42");
            Assertions.assertThat((Throwable)context.getError()).isSameAs((Object)exception);
            ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)context.toString()).containsOnlyOnce((CharSequence)"name='test.observation'")).containsOnlyOnce((CharSequence)"contextualName='test.observation.42'")).containsOnlyOnce((CharSequence)"error='java.io.IOException: simulated'")).containsOnlyOnce((CharSequence)"lowCardinalityKeyValues=[global.context.class='TestContext', lcTag1='1', lcTag2='2']")).containsOnlyOnce((CharSequence)("highCardinalityKeyValues=[global.uuid='" + testContext.uuid + "', hcTag1='3', hcTag2='4']"))).containsOnlyOnce((CharSequence)"map=[context.field='42']");
        });
    }

    @Test
    void globallyOverriddenNameAndContextualNameShouldBeSetOnContext() {
        AssertingHandler assertingHandler = new AssertingHandler();
        this.registry.observationConfig().observationConvention((GlobalObservationConvention)new TestObservationConventionWithNameOverrides()).observationHandler((ObservationHandler)assertingHandler);
        TestContext testContext = new TestContext();
        Observation observation = Observation.createNotStarted((String)"test.observation", () -> testContext, (ObservationRegistry)this.registry).contextualName("test.observation.42").start();
        observation.stop();
        assertingHandler.checkAssertions(context -> {
            Assertions.assertThat((String)context.getName()).isEqualTo("conventionOverriddenName");
            Assertions.assertThat((String)context.getContextualName()).isEqualTo("conventionOverriddenContextualName");
            ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)context.toString()).containsOnlyOnce((CharSequence)"name='conventionOverriddenName'")).containsOnlyOnce((CharSequence)"contextualName='conventionOverriddenContextualName'")).containsOnlyOnce((CharSequence)"error='null'")).containsOnlyOnce((CharSequence)"lowCardinalityKeyValues=[]")).containsOnlyOnce((CharSequence)"highCardinalityKeyValues=[]")).containsOnlyOnce((CharSequence)"map=[]");
        });
    }

    @Test
    void locallyOverriddenNameAndContextualNameShouldBeSetOnContext() {
        AssertingHandler assertingHandler = new AssertingHandler();
        this.registry.observationConfig().observationHandler((ObservationHandler)assertingHandler);
        TestContext testContext = new TestContext();
        Observation observation = Observation.createNotStarted((String)"test.observation", () -> testContext, (ObservationRegistry)this.registry).contextualName("test.observation.42").observationConvention((ObservationConvention)new TestObservationConventionWithNameOverrides()).start();
        observation.stop();
        assertingHandler.checkAssertions(context -> {
            Assertions.assertThat((String)context.getName()).isEqualTo("conventionOverriddenName");
            Assertions.assertThat((String)context.getContextualName()).isEqualTo("conventionOverriddenContextualName");
            ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)context.toString()).containsOnlyOnce((CharSequence)"name='conventionOverriddenName'")).containsOnlyOnce((CharSequence)"contextualName='conventionOverriddenContextualName'")).containsOnlyOnce((CharSequence)"error='null'")).containsOnlyOnce((CharSequence)"lowCardinalityKeyValues=[]")).containsOnlyOnce((CharSequence)"highCardinalityKeyValues=[]")).containsOnlyOnce((CharSequence)"map=[]");
        });
    }

    static class AssertingHandler
    implements ObservationHandler<Observation.Context> {
        private boolean stopped = false;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Observation.Context context = null;

        AssertingHandler() {
        }

        public void onStop(Observation.Context context) {
            this.stopped = true;
            this.context = context;
        }

        public boolean supportsContext(Observation.Context context) {
            return true;
        }

        public void checkAssertions(Consumer<Observation.Context> checker) {
            Assertions.assertThat((boolean)this.stopped).isTrue();
            Assertions.assertThat((Object)this.context).isNotNull();
            checker.accept(this.context);
        }
    }

    static class TestObservationConvention
    implements GlobalObservationConvention<TestContext> {
        private final String id;

        public TestObservationConvention(String id) {
            this.id = id;
        }

        public KeyValues getLowCardinalityKeyValues(TestContext context) {
            return KeyValues.of((String)(this.id + ".context.class"), (String)TestContext.class.getSimpleName());
        }

        public KeyValues getHighCardinalityKeyValues(TestContext context) {
            return KeyValues.of((String)(this.id + ".uuid"), (String)context.uuid);
        }

        public boolean supportsContext(Observation.Context context) {
            return context instanceof TestContext;
        }
    }

    static class UnsupportedObservationConvention
    implements GlobalObservationConvention<Observation.Context> {
        private final String id;

        public UnsupportedObservationConvention(String id) {
            this.id = id;
        }

        public KeyValues getLowCardinalityKeyValues(Observation.Context context) {
            return KeyValues.of((String)(this.id + ".unsupported.lc"), (String)"unsupported");
        }

        public KeyValues getHighCardinalityKeyValues(Observation.Context context) {
            return KeyValues.of((String)(this.id + ".unsupported.hc"), (String)"unsupported");
        }

        public boolean supportsContext(Observation.Context context) {
            return false;
        }
    }

    static class TestContext
    extends Observation.Context {
        final String uuid = UUID.randomUUID().toString();

        TestContext() {
        }
    }

    static class TestObservationConventionWithNameOverrides
    implements GlobalObservationConvention<TestContext> {
        TestObservationConventionWithNameOverrides() {
        }

        public String getName() {
            return "conventionOverriddenName";
        }

        public String getContextualName(TestContext context) {
            return "conventionOverriddenContextualName";
        }

        public boolean supportsContext(Observation.Context context) {
            return context instanceof TestContext;
        }
    }
}

