/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jetty12.server;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.jetty12.server.JettyCoreRequestTagsProvider;
import org.eclipse.jetty.server.Request;

public class DefaultJettyCoreRequestTagsProvider
implements JettyCoreRequestTagsProvider {
    private static final Tag STATUS_UNKNOWN = Tag.of((String)"status", (String)"UNKNOWN");
    private static final Tag METHOD_UNKNOWN = Tag.of((String)"method", (String)"UNKNOWN");

    @Override
    public Iterable<Tag> getTags(Request request) {
        return Tags.of((Tag[])new Tag[]{this.method(request), this.status(request), this.outcome(request)});
    }

    private Tag method(Request request) {
        return request != null ? Tag.of((String)"method", (String)request.getMethod()) : METHOD_UNKNOWN;
    }

    private Tag status(Request request) {
        if (request == null) {
            return STATUS_UNKNOWN;
        }
        Object status = request.getAttribute("__micrometer_jetty_core_response_status");
        if (status instanceof Integer) {
            Integer statusInt = (Integer)status;
            return Tag.of((String)"status", (String)Integer.toString(statusInt));
        }
        return STATUS_UNKNOWN;
    }

    private Tag outcome(Request request) {
        Object status;
        Outcome outcome = Outcome.UNKNOWN;
        if (request != null && (status = request.getAttribute("__micrometer_jetty_core_response_status")) instanceof Integer) {
            Integer statusInt = (Integer)status;
            outcome = Outcome.forStatus((int)statusInt);
        }
        return outcome.asTag();
    }
}

