/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jetty11;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.http.DefaultHttpJakartaServletRequestTagsProvider;
import io.micrometer.core.instrument.binder.http.HttpJakartaServletRequestTagsProvider;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.component.Graceful;

@Deprecated
public class TimedHandler
extends HandlerWrapper
implements Graceful {
    private static final String SAMPLE_REQUEST_TIMER_ATTRIBUTE = "__micrometer_timer_sample";
    private static final String SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE = "__micrometer_ltt_sample";
    private final MeterRegistry registry;
    private final Iterable<Tag> tags;
    private final HttpJakartaServletRequestTagsProvider tagsProvider;
    private final Graceful.Shutdown shutdown = new Graceful.Shutdown((Object)this){

        public boolean isShutdownDone() {
            return TimedHandler.this.openRequests.activeTasks() == 0;
        }
    };
    private final LongTaskTimer openRequests;
    private final Counter asyncDispatches;
    private final Counter asyncExpires;
    private final AtomicInteger asyncWaits = new AtomicInteger();
    private final AsyncListener onCompletion = new AsyncListener(){

        public void onTimeout(AsyncEvent event) {
            TimedHandler.this.asyncExpires.increment();
            HttpChannelState state = ((AsyncContextEvent)event).getHttpChannelState();
            Request request = state.getBaseRequest();
            LongTaskTimer.Sample lttSample = (LongTaskTimer.Sample)request.getAttribute(TimedHandler.SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE);
            lttSample.stop();
        }

        public void onStartAsync(AsyncEvent event) {
            event.getAsyncContext().addListener((AsyncListener)this);
        }

        public void onError(AsyncEvent event) {
        }

        public void onComplete(AsyncEvent event) {
            HttpChannelState state = ((AsyncContextEvent)event).getHttpChannelState();
            Request request = state.getBaseRequest();
            Timer.Sample sample = (Timer.Sample)request.getAttribute(TimedHandler.SAMPLE_REQUEST_TIMER_ATTRIBUTE);
            LongTaskTimer.Sample lttSample = (LongTaskTimer.Sample)request.getAttribute(TimedHandler.SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE);
            if (sample != null) {
                sample.stop(Timer.builder((String)"jetty.server.requests").description("HTTP requests to the Jetty server").tags(TimedHandler.this.tagsProvider.getTags((HttpServletRequest)request, (HttpServletResponse)request.getResponse())).tags(TimedHandler.this.tags).register(TimedHandler.this.registry));
                lttSample.stop();
            }
            TimedHandler.this.asyncWaits.decrementAndGet();
            if (TimedHandler.this.shutdown.isShutdown()) {
                TimedHandler.this.shutdown.check();
            }
        }
    };

    public TimedHandler(MeterRegistry registry, Iterable<Tag> tags) {
        this(registry, tags, (HttpJakartaServletRequestTagsProvider)new DefaultHttpJakartaServletRequestTagsProvider());
    }

    public TimedHandler(MeterRegistry registry, Iterable<Tag> tags, HttpJakartaServletRequestTagsProvider tagsProvider) {
        this.registry = registry;
        this.tags = tags;
        this.tagsProvider = tagsProvider;
        this.openRequests = LongTaskTimer.builder((String)"jetty.server.dispatches.open").description("Jetty dispatches that are currently in progress").tags(tags).register(registry);
        this.asyncDispatches = Counter.builder((String)"jetty.server.async.dispatches").description("Asynchronous dispatches").tags(tags).register(registry);
        this.asyncExpires = Counter.builder((String)"jetty.server.async.expires").description("Asynchronous operations that timed out before completing").tags(tags).register(registry);
        Gauge.builder((String)"jetty.server.async.waits", (Object)this.asyncWaits, AtomicInteger::doubleValue).description("Pending asynchronous wait operations").baseUnit("operations").tags(tags).register(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LongTaskTimer.Sample requestSample;
        Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
        HttpChannelState state = baseRequest.getHttpChannelState();
        if (state.isInitial()) {
            requestSample = this.openRequests.start();
            request.setAttribute(SAMPLE_REQUEST_TIMER_ATTRIBUTE, (Object)sample);
            request.setAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE, (Object)requestSample);
        } else {
            this.asyncDispatches.increment();
            request.setAttribute(SAMPLE_REQUEST_TIMER_ATTRIBUTE, (Object)sample);
            requestSample = (LongTaskTimer.Sample)request.getAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE);
        }
        try {
            Handler handler = this.getHandler();
            if (handler != null && !this.shutdown.isShutdown() && this.isStarted()) {
                handler.handle(path, baseRequest, request, response);
            } else {
                if (!baseRequest.isHandled()) {
                    baseRequest.setHandled(true);
                }
                if (!baseRequest.getResponse().isCommitted()) {
                    response.sendError(503);
                }
            }
        }
        finally {
            if (state.isSuspended()) {
                if (state.isInitial()) {
                    state.addListener(this.onCompletion);
                    this.asyncWaits.incrementAndGet();
                }
            } else if (state.isInitial()) {
                sample.stop(Timer.builder((String)"jetty.server.requests").description("HTTP requests to the Jetty server").tags(this.tagsProvider.getTags(request, response)).tags(this.tags).register(this.registry));
                requestSample.stop();
                if (this.shutdown.isShutdown()) {
                    this.shutdown.check();
                }
            }
        }
    }

    protected void doStart() throws Exception {
        this.shutdown.cancel();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.shutdown.cancel();
        super.doStop();
    }

    public CompletableFuture<Void> shutdown() {
        return this.shutdown.shutdown();
    }

    public boolean isShutdown() {
        return this.shutdown.isShutdown();
    }
}

