/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.java21.instrument.binder.jdk;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import jdk.jfr.consumer.RecordingStream;

public class VirtualThreadMetrics
implements MeterBinder,
Closeable {
    private static final String PINNED_EVENT = "jdk.VirtualThreadPinned";
    private static final String SUBMIT_FAILED_EVENT = "jdk.VirtualThreadSubmitFailed";
    private final RecordingStream recordingStream;
    private final Iterable<Tag> tags;

    public VirtualThreadMetrics() {
        this(new RecordingConfig(), Collections.emptyList());
    }

    public VirtualThreadMetrics(Iterable<Tag> tags) {
        this(new RecordingConfig(), tags);
    }

    private VirtualThreadMetrics(RecordingConfig config, Iterable<Tag> tags) {
        this.recordingStream = this.createRecordingStream(config);
        this.tags = tags;
    }

    public void bindTo(MeterRegistry registry) {
        Timer pinnedTimer = Timer.builder((String)"jvm.threads.virtual.pinned").description("The duration while the virtual thread was pinned without releasing its platform thread").tags(this.tags).register(registry);
        Counter submitFailedCounter = Counter.builder((String)"jvm.threads.virtual.submit.failed").description("The number of events when starting or unparking a virtual thread failed").tags(this.tags).register(registry);
        this.recordingStream.onEvent(PINNED_EVENT, event -> pinnedTimer.record(event.getDuration()));
        this.recordingStream.onEvent(SUBMIT_FAILED_EVENT, event -> submitFailedCounter.increment());
    }

    private RecordingStream createRecordingStream(RecordingConfig config) {
        RecordingStream recordingStream = new RecordingStream();
        recordingStream.enable(PINNED_EVENT).withThreshold(config.pinnedThreshold);
        recordingStream.enable(SUBMIT_FAILED_EVENT);
        recordingStream.setMaxAge(config.maxAge);
        recordingStream.setMaxSize(config.maxSizeBytes);
        recordingStream.startAsync();
        return recordingStream;
    }

    @Override
    public void close() {
        this.recordingStream.close();
    }

    private record RecordingConfig(Duration maxAge, long maxSizeBytes, Duration pinnedThreshold) {
        private RecordingConfig() {
            this(Duration.ofSeconds(5L), 0xA00000L, Duration.ofMillis(20L));
        }

        private RecordingConfig {
            Objects.requireNonNull(maxAge, "maxAge parameter must not be null");
            Objects.requireNonNull(pinnedThreshold, "pinnedThreshold must not be null");
            if (maxSizeBytes < 0L) {
                throw new IllegalArgumentException("maxSizeBytes must be positive");
            }
        }
    }
}

