/*
 * Decompiled with CFR 0.152.
 */
package io.michaelrocks.libphonenumber.android.metadata.source;

import io.michaelrocks.libphonenumber.android.MetadataLoader;
import io.michaelrocks.libphonenumber.android.Phonemetadata;
import io.michaelrocks.libphonenumber.android.internal.GeoEntityUtility;
import io.michaelrocks.libphonenumber.android.metadata.init.MetadataParser;
import io.michaelrocks.libphonenumber.android.metadata.source.BlockingMetadataBootstrappingGuard;
import io.michaelrocks.libphonenumber.android.metadata.source.CompositeMetadataContainer;
import io.michaelrocks.libphonenumber.android.metadata.source.MetadataBootstrappingGuard;
import io.michaelrocks.libphonenumber.android.metadata.source.MetadataSource;
import io.michaelrocks.libphonenumber.android.metadata.source.PhoneMetadataFileNameProvider;

public final class MetadataSourceImpl
implements MetadataSource {
    private final PhoneMetadataFileNameProvider phoneMetadataFileNameProvider;
    private final MetadataBootstrappingGuard<CompositeMetadataContainer> bootstrappingGuard;

    public MetadataSourceImpl(PhoneMetadataFileNameProvider phoneMetadataFileNameProvider, MetadataBootstrappingGuard<CompositeMetadataContainer> bootstrappingGuard) {
        this.phoneMetadataFileNameProvider = phoneMetadataFileNameProvider;
        this.bootstrappingGuard = bootstrappingGuard;
    }

    public MetadataSourceImpl(PhoneMetadataFileNameProvider phoneMetadataFileNameProvider, MetadataLoader metadataLoader, MetadataParser metadataParser) {
        this(phoneMetadataFileNameProvider, new BlockingMetadataBootstrappingGuard<CompositeMetadataContainer>(metadataLoader, metadataParser, new CompositeMetadataContainer()));
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        if (GeoEntityUtility.isGeoEntity(countryCallingCode)) {
            throw new IllegalArgumentException(countryCallingCode + " calling code belongs to a geo entity");
        }
        return this.bootstrappingGuard.getOrBootstrap(this.phoneMetadataFileNameProvider.getFor(countryCallingCode)).getMetadataBy(countryCallingCode);
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        if (!GeoEntityUtility.isGeoEntity(regionCode)) {
            throw new IllegalArgumentException(regionCode + " region code is a non-geo entity");
        }
        return this.bootstrappingGuard.getOrBootstrap(this.phoneMetadataFileNameProvider.getFor(regionCode)).getMetadataBy(regionCode);
    }
}

