/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import com.sun.nio.file.ExtendedWatchEventModifier;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.PathUtils;
import io.methvin.watcher.hashing.FileHasher;
import io.methvin.watcher.hashing.HashCode;
import io.methvin.watchservice.MacOSXListeningWatchService;
import io.methvin.watchservice.WatchablePath;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher {
    private final Logger logger;
    private final WatchService watchService;
    private final Map<Path, Path> registeredPathToRootPath = new HashMap<Path, Path>();
    private final boolean isMac;
    private final DirectoryChangeListener listener;
    private final SortedMap<Path, HashCode> pathHashes;
    private final Map<WatchKey, Path> keyRoots;
    private Boolean fileTreeSupported = null;
    private FileHasher fileHasher;
    private volatile boolean closed = false;

    public static Builder builder() {
        return new Builder();
    }

    public DirectoryWatcher(List<Path> list, DirectoryChangeListener directoryChangeListener, WatchService watchService, FileHasher fileHasher, Logger logger) throws IOException {
        this.listener = directoryChangeListener;
        this.watchService = watchService;
        this.isMac = watchService instanceof MacOSXListeningWatchService;
        this.pathHashes = PathUtils.createHashCodeMap(list, fileHasher);
        this.keyRoots = PathUtils.createKeyRootsMap();
        this.fileHasher = fileHasher;
        this.logger = logger;
        for (Path path : list) {
            this.registerAll(path, path);
        }
    }

    public CompletableFuture<Void> watchAsync() {
        return this.watchAsync(ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> watchAsync(Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            this.watch();
            return null;
        }, executor);
    }

    public void watch() {
        while (this.listener.isWatching()) {
            WatchKey watchKey;
            try {
                watchKey = this.watchService.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                try {
                    Object object;
                    Object object2;
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    WatchEvent watchEvent2 = PathUtils.cast(watchEvent);
                    int n = watchEvent2.count();
                    Path path = (Path)watchEvent2.context();
                    if (!this.keyRoots.containsKey(watchKey)) {
                        throw new IllegalStateException("WatchService returned key [" + watchKey + "] but it was not found in keyRoots!");
                    }
                    Path path3 = this.keyRoots.get(watchKey);
                    Path path4 = this.registeredPathToRootPath.get(path3);
                    Path path5 = path == null ? null : this.keyRoots.get(watchKey).resolve(path);
                    this.logger.debug("{} [{}]", kind, (Object)path5);
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.onEvent(DirectoryChangeEvent.EventType.OVERFLOW, path5, n, path4);
                        continue;
                    }
                    if (path == null) {
                        throw new IllegalStateException("WatchService returned a null path for " + kind.name());
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        if (Files.isDirectory(path5, LinkOption.NOFOLLOW_LINKS)) {
                            if (!Boolean.TRUE.equals(this.fileTreeSupported)) {
                                this.registerAll(path5, path4);
                            }
                            if (!this.isMac) {
                                PathUtils.recursiveVisitFiles(path5, path2 -> this.notifyCreateEvent(path2, n, path4), path2 -> this.notifyCreateEvent(path2, n, path4));
                            }
                        }
                        this.notifyCreateEvent(path5, n, path4);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        if (this.fileHasher == null) {
                            this.onEvent(DirectoryChangeEvent.EventType.MODIFY, path5, n, path4);
                            continue;
                        }
                        object2 = (HashCode)this.pathHashes.get(path5);
                        object = PathUtils.hash(this.fileHasher, path5);
                        if (object != null && !((HashCode)object).equals(object2)) {
                            this.pathHashes.put(path5, (HashCode)object);
                            this.onEvent(DirectoryChangeEvent.EventType.MODIFY, path5, n, path4);
                            continue;
                        }
                        if (object != null) continue;
                        this.logger.debug("Failed to hash modified file [{}]. It may have been deleted.", (Object)path5);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    if (this.fileHasher == null) {
                        this.onEvent(DirectoryChangeEvent.EventType.DELETE, path5, n, path4);
                        continue;
                    }
                    object2 = this.pathHashes.subMap(path5, Paths.get(path5.toString(), "\uffff")).keySet();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Path path6 = (Path)object.next();
                        this.onEvent(DirectoryChangeEvent.EventType.DELETE, path6, n, path4);
                    }
                    object2.clear();
                }
                catch (Exception exception) {
                    this.logger.debug("DirectoryWatcher got an exception while watching!", (Throwable)exception);
                    this.listener.onException(exception);
                }
            }
            boolean bl = watchKey.reset();
            if (bl) continue;
            this.logger.debug("WatchKey for [{}] no longer valid; removing.", (Object)watchKey.watchable());
            Path path = this.keyRoots.remove(watchKey);
            this.registeredPathToRootPath.remove(path);
            if (!this.keyRoots.isEmpty()) continue;
            this.logger.debug("No more directories left to watch; terminating watcher.");
            break;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private void onEvent(DirectoryChangeEvent.EventType eventType, Path path, int n, Path path2) throws IOException {
        this.logger.debug("-> {} [{}]", (Object)eventType, (Object)path);
        this.listener.onEvent(new DirectoryChangeEvent(eventType, path, n, path2));
    }

    public DirectoryChangeListener getListener() {
        return this.listener;
    }

    public void close() throws IOException {
        this.watchService.close();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void registerAll(Path path3, Path path4) throws IOException {
        if (!Boolean.FALSE.equals(this.fileTreeSupported)) {
            try {
                this.register(path3, true, path4);
                this.fileTreeSupported = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.logger.debug("Assuming ExtendedWatchEventModifier.FILE_TREE is not supported", (Throwable)unsupportedOperationException);
                this.fileTreeSupported = false;
                this.registerAll(path3, path4);
            }
        } else {
            PathUtils.recursiveVisitFiles(path3, path2 -> this.register(path2, false, path4), path -> {});
        }
    }

    private void register(Path path, boolean bl, Path path2) throws IOException {
        WatchEvent.Modifier[] modifierArray;
        Watchable watchable;
        this.logger.debug("Registering [{}].", (Object)path);
        Watchable watchable2 = watchable = this.isMac ? new WatchablePath(path) : path;
        if (bl) {
            WatchEvent.Modifier[] modifierArray2 = new WatchEvent.Modifier[1];
            modifierArray = modifierArray2;
            modifierArray2[0] = ExtendedWatchEventModifier.FILE_TREE;
        } else {
            modifierArray = new WatchEvent.Modifier[]{};
        }
        WatchEvent.Modifier[] modifierArray3 = modifierArray;
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        WatchKey watchKey = watchable.register(this.watchService, kindArray, modifierArray3);
        this.keyRoots.put(watchKey, path);
        this.registeredPathToRootPath.put(path, path2);
    }

    private void notifyCreateEvent(Path path, int n, Path path2) throws IOException {
        if (this.fileHasher == null) {
            this.onEvent(DirectoryChangeEvent.EventType.CREATE, path, n, path2);
        } else {
            HashCode hashCode = PathUtils.hash(this.fileHasher, path);
            if (hashCode == null) {
                if (Files.notExists(path, new LinkOption[0])) {
                    this.logger.debug("Failed to hash created file [{}]. It may have been deleted.", (Object)path);
                } else {
                    this.logger.debug("Failed to hash created file [{}]. It may be locked.", (Object)path);
                    this.onEvent(DirectoryChangeEvent.EventType.CREATE, path, n, path2);
                }
            } else if (!this.pathHashes.containsKey(path)) {
                this.onEvent(DirectoryChangeEvent.EventType.CREATE, path, n, path2);
                this.pathHashes.put(path, hashCode);
            }
        }
    }

    public static final class Builder {
        private List<Path> paths = Collections.emptyList();
        private DirectoryChangeListener listener = directoryChangeEvent -> {};
        private Logger logger = null;
        private FileHasher fileHasher = FileHasher.DEFAULT_FILE_HASHER;
        private WatchService watchService = null;

        private Builder() {
        }

        public Builder paths(List<Path> list) {
            this.paths = list;
            return this;
        }

        public Builder path(Path path) {
            return this.paths(Collections.singletonList(path));
        }

        public Builder listener(DirectoryChangeListener directoryChangeListener) {
            this.listener = directoryChangeListener;
            return this;
        }

        public Builder watchService(WatchService watchService) {
            this.watchService = watchService;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder fileHashing(boolean bl) {
            this.fileHasher = bl ? FileHasher.DEFAULT_FILE_HASHER : null;
            return this;
        }

        public Builder fileHasher(FileHasher fileHasher) {
            this.fileHasher = fileHasher;
            return this;
        }

        public DirectoryWatcher build() throws IOException {
            if (this.watchService == null) {
                this.osDefaultWatchService();
            }
            if (this.logger == null) {
                this.staticLogger();
            }
            return new DirectoryWatcher(this.paths, this.listener, this.watchService, this.fileHasher, this.logger);
        }

        private Builder osDefaultWatchService() throws IOException {
            boolean bl = System.getProperty("os.name").toLowerCase().contains("mac");
            if (bl) {
                return this.watchService(new MacOSXListeningWatchService(new MacOSXListeningWatchService.Config(){

                    @Override
                    public FileHasher fileHasher() {
                        return fileHasher;
                    }
                }));
            }
            return this.watchService(FileSystems.getDefault().newWatchService());
        }

        private Builder staticLogger() {
            return this.logger(LoggerFactory.getLogger(DirectoryWatcher.class));
        }
    }
}

