/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Objects;

public final class DirectoryChangeEvent {
    private final EventType eventType;
    private final Path path;
    private final int count;

    public DirectoryChangeEvent(EventType eventType, Path path, int n) {
        this.eventType = eventType;
        this.path = path;
        this.count = n;
    }

    public EventType eventType() {
        return this.eventType;
    }

    public Path path() {
        return this.path;
    }

    public int count() {
        return this.count;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DirectoryChangeEvent directoryChangeEvent = (DirectoryChangeEvent)object;
        return this.count == directoryChangeEvent.count && this.eventType == directoryChangeEvent.eventType && Objects.equals(this.path, directoryChangeEvent.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.path, this.count});
    }

    public String toString() {
        return "DirectoryChangeEvent{eventType=" + (Object)((Object)this.eventType) + ", path=" + this.path + ", count=" + this.count + '}';
    }

    public static enum EventType {
        CREATE(StandardWatchEventKinds.ENTRY_CREATE),
        MODIFY(StandardWatchEventKinds.ENTRY_MODIFY),
        DELETE(StandardWatchEventKinds.ENTRY_DELETE),
        OVERFLOW(StandardWatchEventKinds.OVERFLOW);

        private WatchEvent.Kind<?> kind;

        private EventType(WatchEvent.Kind<?> kind) {
            this.kind = kind;
        }

        public WatchEvent.Kind<?> getWatchEventKind() {
            return this.kind;
        }
    }
}

