/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.MultivariantPlaylist;
import io.lindstrom.m3u8.parser.AbstractPlaylistParser;
import io.lindstrom.m3u8.parser.MultivariantPlaylistTag;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import io.lindstrom.m3u8.parser.VariantAttribute;
import java.util.Iterator;

public class MultivariantPlaylistParser
extends AbstractPlaylistParser<MultivariantPlaylist, MultivariantPlaylist.Builder> {
    private final ParsingMode parsingMode;

    public MultivariantPlaylistParser() {
        this(ParsingMode.STRICT);
    }

    public MultivariantPlaylistParser(ParsingMode parsingMode) {
        this.parsingMode = parsingMode;
    }

    @Override
    void write(MultivariantPlaylist playlist, TextBuilder textBuilder) {
        for (MultivariantPlaylistTag tag : MultivariantPlaylistTag.tags.values()) {
            tag.write(playlist, textBuilder);
        }
    }

    @Override
    MultivariantPlaylist.Builder newBuilder() {
        return MultivariantPlaylist.builder();
    }

    @Override
    void onTag(MultivariantPlaylist.Builder builder, String name, String attributes, Iterator<String> lineIterator) throws PlaylistParserException {
        MultivariantPlaylistTag tag = MultivariantPlaylistTag.tags.get(name);
        if (tag == MultivariantPlaylistTag.EXT_X_STREAM_INF) {
            String uriLine = lineIterator.next();
            if (uriLine == null || uriLine.startsWith("#")) {
                throw new PlaylistParserException("Expected URI, got " + uriLine);
            }
            builder.addVariants(VariantAttribute.parse(attributes, uriLine, this.parsingMode));
        } else if (tag != null) {
            tag.read(builder, attributes, this.parsingMode);
        } else if (this.parsingMode.failOnUnknownTags()) {
            throw new PlaylistParserException("Tag not implemented: " + name);
        }
    }

    @Override
    void onComment(MultivariantPlaylist.Builder builder, String value) {
        builder.addComments(value);
    }

    @Override
    MultivariantPlaylist build(MultivariantPlaylist.Builder builder) {
        return builder.build();
    }
}

